package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.subsystem.imagehandling.data.TriggerSimulatedImage;
import org.lsst.ccs.utilities.location.LocationSet;

/**
 * An implementation of CCSPlayList which does not require any DAQ at all. 
 * Instead raw and meta files are stored in a directory, and a TriggerSimulatedImage
 * event is sent to cause the image-handlers to "read out" the simulated image.
 * @author tonyj
 */
public class CCSSimulatedPlayList extends CCSPlayList {

    private static final Logger LOG = Logger.getLogger(CCSSimulatedPlayList.class.getName());
    private final SequencerConfig config;
    private final FocalPlaneSubsystem subsys;
    private final String emulatedDAQFolder;
    private final String emulatedDataFolder;
    
    CCSSimulatedPlayList(CCSImageList imageList, boolean repeat, FocalPlaneSubsystem subsys, SequencerConfig config) throws DAQException, IOException {
        super(imageList, repeat);
        this.subsys = subsys;
        this.config = config;
        this.emulatedDAQFolder = imageList.getDAQFolder();
        // This is the folder containing the raw and meta files.
        this.emulatedDataFolder = imageList.getDataFolder();
    }
    
    @Override
    void play(String emulatedImageName, String triggeredImageName, LocationSet effectiveLocations,  int opCode, String annotation) throws IOException, DAQException {
        TriggerSimulatedImage tsi = new TriggerSimulatedImage(triggeredImageName, config.getDAQFolder(), emulatedImageName, emulatedDAQFolder, emulatedDataFolder, effectiveLocations, opCode, annotation);
        subsys.sendEvent(TriggerSimulatedImage.EVENT_KEY, tsi);
    }
}
