/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.channel.FilterReadableIntChannel;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;

public class Compress18BitChannel
extends FilterReadableIntChannel {
    private static boolean ERROR_ON_BAD_DATA = false;
    private static final Logger LOG = Logger.getLogger(Compress18BitChannel.class.getName());
    private int bitsAvailable = 0;
    private long dataAvailable = 0L;

    Compress18BitChannel(ReadableIntChannel input) {
        super(input);
    }

    @Override
    public int read() throws IOException {
        while (this.bitsAvailable < 32) {
            int data = this.input.read();
            if (data < 0 || data > 262143) {
                if (ERROR_ON_BAD_DATA) {
                    throw new IOException("Invalid 18 bit data: " + Integer.toHexString(data));
                }
                int newData = data;
                newData = data < 0 ? 0 : 262143;
                LOG.log(Level.WARNING, "Invalid 18 bit data: {0} treated as {1}", new Object[]{Integer.toHexString(data), Integer.toHexString(newData)});
                data = newData;
            }
            long in = (long)data & 0x3FFFFL;
            this.dataAvailable |= in << this.bitsAvailable;
            this.bitsAvailable += 18;
        }
        int result = (int)this.dataAvailable;
        this.bitsAvailable -= 32;
        this.dataAvailable >>= 32;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        if (this.bitsAvailable != 0) {
            throw new IOException("Unused data remaining on close");
        }
    }
}

