/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.ImageDatabase;
import org.lsst.ccs.subsystem.focalplane.ImageDatabaseService;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageDatabaseTest {
    static String createConnection() {
        return "jdbc:h2:mem:test;MODE=MYSQL";
    }

    @Test
    public void testImageDatabase() throws SQLException {
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)ImageDatabaseTest.createConnection());
        try (ImageDatabase idb = idbs.getImageDatabase();){
            ImageName in = new ImageName("MC_C_20190610_001309");
            ImageDatabase.ImageDAO dao = idb.start(in);
            HashMap<String, Double> metaMap = new HashMap<String, Double>();
            metaMap.put("ExposureTime", 15.0);
            dao.addMetaData(metaMap);
            Instant obsDate = Instant.now();
            dao.setObsDate(obsDate);
            dao.setDaqTag(1234567890L);
            dao.setDarkTime(42.0);
            FileList fitsFiles = new FileList();
            fitsFiles.add((Object)new File("/abc"));
            dao.add(fitsFiles);
            dao.commit();
            PreparedStatement stmt = idb.getConnection().prepareStatement("select * from ccs_image where obsDate = ?");
            stmt.setTimestamp(1, Timestamp.from(obsDate));
            ResultSet rs = stmt.executeQuery();
            rs.next();
            Assert.assertEquals((double)15.0, (double)rs.getDouble("exposureTime"), (double)0.1);
            Assert.assertEquals((long)1234567890L, (long)rs.getLong("imageTag"));
            Assert.assertEquals((double)42.0, (double)rs.getLong("darkTime"), (double)0.1);
        }
    }

    @Test
    public void testRaftMaskFromLocations() {
        LocationSet locations = LocationSet.of((String[])new String[]{"R22,R44"});
        int raftMask = ImageDatabase.raftsMaskFromLocations((LocationSet)locations);
        Assert.assertEquals((long)0x1001000L, (long)raftMask);
    }
}

