/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.channel.FilterWritableIntChannel;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;

public class BadPixelDetector
extends FilterWritableIntChannel {
    private int nTotal = 0;
    private int nBad = 0;
    private final int lowThreshold;
    private final int highThreshold;
    private static final Logger LOG = Logger.getLogger(BadPixelDetector.class.getName());

    public BadPixelDetector(WritableIntChannel input) {
        this(input, 10000, 240000);
    }

    public BadPixelDetector(WritableIntChannel input, int lowThreshold, int highThreshold) {
        super(input);
        this.lowThreshold = lowThreshold;
        this.highThreshold = highThreshold;
    }

    @Override
    public void write(int i) throws IOException {
        if (i < this.lowThreshold || i > this.highThreshold) {
            ++this.nBad;
            LOG.log(Level.FINER, () -> String.format("Bad pixel %d at %d\n", i, this.nTotal));
        }
        this.input.write(i);
        ++this.nTotal;
    }

    public int getTotalPixels() {
        return this.nTotal;
    }

    public int getBadPixels() {
        return this.nBad;
    }

    public int getLowThreshold() {
        return this.lowThreshold;
    }

    public int getHighThreshold() {
        return this.highThreshold;
    }
}

