/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.zip.GZIPInputStream;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public abstract class BusMessage<T extends Serializable, D>
implements Serializable {
    private static final long serialVersionUID = -51335689636909L;
    private final SerializationUtils<T> serializationUtils = new SerializationUtils();
    private D encodedData;
    private byte[] serializedObject;
    private transient T deserializedObject = null;
    private String className = "";
    private AgentInfo originAgentInfo;
    private volatile transient CCSTimeStamp deserializationTimeStamp;
    private volatile transient CCSTimeStamp doneDeserializationTimeStamp;
    private volatile CCSTimeStamp serializationTimeStamp;
    private volatile transient CCSTimeStamp doneSerializationTimeStamp;
    private CCSTimeStamp ccsTimeStamp = CCSTimeStamp.currentTime();
    protected final transient T obj;
    private final String compressionProtocol;
    private volatile transient CCSTimeStamp incomingQueueInTimeStamp;
    private volatile transient CCSTimeStamp incomingQueueOutTimeStamp;
    private volatile CCSTimeStamp outgoingQueueInTimeStamp;
    private volatile CCSTimeStamp outgoingQueueOutTimeStamp;

    public BusMessage(Class clazz, byte[] ser, String compressionProtocol) {
        this.className = clazz.getName();
        this.encodedData = null;
        this.serializedObject = ser;
        this.obj = null;
        this.compressionProtocol = compressionProtocol;
        if (!compressionProtocol.equals("none") && !compressionProtocol.equals("gzip")) {
            throw new RuntimeException("Unknown compression protocol: " + compressionProtocol);
        }
    }

    public BusMessage(T obj) {
        this(obj, false);
    }

    public BusMessage(T obj, boolean skipSerialization) {
        this.obj = obj;
        if (obj != null) {
            if (!skipSerialization) {
                try {
                    this.serializedObject = this.serializationUtils.serialize(obj);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Could not serialize object.", ioe);
                }
            } else {
                this.serializedObject = null;
            }
            this.encodedData = this.encodeObject(obj);
            this.className = obj.getClass().getName();
        } else {
            this.encodedData = null;
            this.serializedObject = null;
        }
        this.compressionProtocol = "none";
    }

    protected abstract D encodeObject(T var1);

    public String getClassName() {
        return this.className;
    }

    public D getEncodedData() {
        return this.encodedData;
    }

    public T getObject() {
        if (this.obj != null) {
            return this.obj;
        }
        if (this.serializedObject == null) {
            return null;
        }
        if (this.deserializedObject == null) {
            this.deserializedObject = this.serializationUtils.deserialize(this.serializedObject, this.compressionProtocol);
        }
        return this.deserializedObject;
    }

    public AgentInfo getOriginAgentInfo() {
        return this.originAgentInfo;
    }

    public final void setOriginAgentInfo(AgentInfo agent) {
        if (this.originAgentInfo != null) {
            throw new RuntimeException("The setOriginAgentInfo method on BusMessage must be invoked only once!!!");
        }
        this.originAgentInfo = agent;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public String toString() {
        D ed;
        StringBuilder sb = new StringBuilder(1);
        String sOrigin = this.getOriginAgentInfo() != null ? this.getOriginAgentInfo().getName() : "notSet";
        sb.append(this.getClass().getSimpleName()).append(" { origin=").append(sOrigin).append("\n");
        sb.append(" creation timestamp=").append(this.getCCSTimeStamp()).append("\n");
        if (!this.className.isEmpty()) {
            sb.append(" className=").append(this.className).append("\n");
        }
        if ((ed = this.getEncodedData()) != null) {
            sb.append(" encodedData:\n").append(ed).append("\n");
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.serializationTimeStamp == null) {
            this.serializationTimeStamp = CCSTimeStamp.currentTime();
        }
        out.defaultWriteObject();
        out.writeObject(CCSTimeStamp.currentTime());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.deserializationTimeStamp == null) {
            this.deserializationTimeStamp = CCSTimeStamp.currentTime();
        }
        in.defaultReadObject();
        try {
            this.doneSerializationTimeStamp = (CCSTimeStamp)in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.doneDeserializationTimeStamp == null) {
            this.doneDeserializationTimeStamp = CCSTimeStamp.currentTime();
        }
    }

    public Duration getTransferDuration() {
        if (this.doneSerializationTimeStamp != null && this.deserializationTimeStamp != null) {
            return Duration.between(this.doneSerializationTimeStamp.getUTCInstant(), this.deserializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    public CCSTimeStamp getDoneDeSerializationTime() {
        return this.deserializationTimeStamp;
    }

    public CCSTimeStamp getSerializationTime() {
        return this.serializationTimeStamp;
    }

    public Duration getSerializationDuration() {
        if (this.serializationTimeStamp != null && this.doneSerializationTimeStamp != null) {
            return Duration.between(this.serializationTimeStamp.getUTCInstant(), this.doneSerializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    public Duration getDeserializationDuration() {
        if (this.deserializationTimeStamp != null && this.doneDeserializationTimeStamp != null) {
            return Duration.between(this.deserializationTimeStamp.getUTCInstant(), this.doneDeserializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    public void updateTimingInformation(BusMessage msg) {
        this.serializationTimeStamp = msg.serializationTimeStamp;
        this.doneSerializationTimeStamp = msg.doneSerializationTimeStamp;
        this.deserializationTimeStamp = msg.deserializationTimeStamp;
        this.doneDeserializationTimeStamp = msg.doneDeserializationTimeStamp;
        this.ccsTimeStamp = msg.ccsTimeStamp;
    }

    public CCSTimeStamp getOutgoingQueueOutTimeStamp() {
        return this.outgoingQueueOutTimeStamp;
    }

    public void setOutgoingQueueOutTimeStamp(CCSTimeStamp outgoingQueueOutTimeStamp) {
        this.outgoingQueueOutTimeStamp = outgoingQueueOutTimeStamp;
    }

    public CCSTimeStamp getOutgoingQueueInTimeStamp() {
        return this.outgoingQueueInTimeStamp;
    }

    public void setOutgoingQueueInTimeStamp(CCSTimeStamp outgoingQueueInTimeStamp) {
        this.outgoingQueueInTimeStamp = outgoingQueueInTimeStamp;
    }

    public CCSTimeStamp getIncomingQueueOutTimeStamp() {
        return this.incomingQueueOutTimeStamp;
    }

    public void setIncomingQueueOutTimeStamp(CCSTimeStamp incomingQueueOutTimeStamp) {
        this.incomingQueueOutTimeStamp = incomingQueueOutTimeStamp;
    }

    public CCSTimeStamp getIncomingQueueInTimeStamp() {
        return this.incomingQueueInTimeStamp;
    }

    public void setIncomingQueueInTimeStamp(CCSTimeStamp incomingQueueInTimeStamp) {
        this.incomingQueueInTimeStamp = incomingQueueInTimeStamp;
    }

    private class SerializationUtils<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = -1377509787159869583L;

        private SerializationUtils() {
        }

        public byte[] serialize(T obj) throws IOException {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                    oos.writeObject(obj);
                    byArray = bos.toByteArray();
                }
                return byArray;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T deserialize(byte[] bytes, String compressionProtocol) throws EmbeddedObjectDeserializationException {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
                InputStream is = bis;
                if (compressionProtocol != null && compressionProtocol.equals("gzip")) {
                    is = new GZIPInputStream(is);
                }
                ObjectInputStream ois = new ObjectInputStream(is);
                Serializable result = (Serializable)ois.readObject();
                is.close();
                ois.close();
                Serializable serializable = result;
                return (T)serializable;
            }
            catch (ClassNotFoundException x) {
                throw new EmbeddedObjectDeserializationException("Class not found while deserializing object embedded in message " + this.getClass(), x);
            }
            catch (IOException x) {
                throw new EmbeddedObjectDeserializationException("Could not deserialize object embedded in message " + this.getClass(), x);
            }
        }
    }
}

