package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Emulator;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Playlist;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.utilities.location.LocationSet;

/**
 * A CCSPlayList implementation which uses the emulated DAQ.
 * It works by creating single image native DAQ playlists as needed.
 * @author tonyj
 */
public class CCSEmulatedPlayList extends CCSPlayList {

    private static final Logger LOG = Logger.getLogger(CCSEmulatedPlayList.class.getName());

    private final Emulator emulator;
    private final Path tempFile;
    private final Store store;
    private final Folder folder;
    
    CCSEmulatedPlayList(CCSImageList imageList, boolean repeat, Store store) throws DAQException, IOException {
        super(imageList, repeat);
        this.store = store;
        this.emulator = store.getEmulator();
        this.folder = store.getCatalog().find(imageList.getDAQFolder());
        this.tempFile = Files.createTempFile("play", "list");
    }
    
    
    @Override
    void play(String emulatedImageName, String triggeredImageName, LocationSet effectiveLocations, int opCode, String annotation) throws DAQException, IOException {
                
        Files.deleteIfExists(tempFile);
        try (Playlist oneImagePlaylist = emulator.openPlaylist(tempFile.toFile())) {
            Image currentImage = folder.find(emulatedImageName);
            LOG.log(Level.INFO, "Created temp playlist {0} with image {1}", new Object[]{tempFile, currentImage.getMetaData().getName()});
            oneImagePlaylist.add(currentImage);
            List<Image> images = oneImagePlaylist.getImages();
            LOG.log(Level.INFO, "Starting temp playlist {0} with image list {1}", new Object[]{tempFile, images});
            oneImagePlaylist.start(false);
            LOG.log(Level.INFO, "Started temp playlist {0} with image list {1}", new Object[]{tempFile, images});
        }
    }

}
