/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class RebDevices {
    private static final Logger LOG = Logger.getLogger(RebDevices.class.getName());
    private final SequencerConfig config;
    private final LocationSet locations;
    private final SequencerMonitor sequencerMonitor;
    private final ReentrantLock sequencerLock = new ReentrantLock();
    private final Condition sequencerStopped = this.sequencerLock.newCondition();
    private final ConcurrentLinkedQueue<Runnable> stoppedQueue = new ConcurrentLinkedQueue();
    private volatile boolean isStarted = false;
    private final ExecutorService executor;

    public RebDevices(ExecutorService executor, SequencerConfig config, LocationSet locations) {
        this.config = config;
        this.locations = locations;
        this.executor = executor;
        this.sequencerMonitor = new SequencerMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        SequencerMonitor sequencerMonitor = this.sequencerMonitor;
        synchronized (sequencerMonitor) {
            if (!this.isStarted) {
                this.executor.execute(this.sequencerMonitor);
                this.isStarted = true;
            }
        }
    }

    boolean areSequencersStopped() throws DAQException {
        Map statusRegisters = this.config.getRegisterClient().readRegisters(this.locations, new int[]{8});
        for (Location l : this.locations) {
            if ((((int[])statusRegisters.get(l))[0] & 4) == 0) continue;
            return false;
        }
        return true;
    }

    void waitSequencersStopped(Duration timeout) throws REBException {
        if (!this.isStarted) {
            this.start();
        }
        try {
            boolean stopped = this.sequencerMonitor.waitSequencersStopped(timeout);
            if (!stopped) {
                throw new REBException("Timedout waiting for sequencers to stop");
            }
        }
        catch (InterruptedException x) {
            throw new REBException("Interrupt while waiting for sequencers to stop");
        }
    }

    void whenSequencersStopped(Runnable runMe) {
        if (!this.isStarted) {
            this.start();
        }
        this.stoppedQueue.offer(runMe);
    }

    private class SequencerMonitor
    implements Runnable {
        private Thread runThread;
        private final long nanos = 1000000L;

        private SequencerMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runThread = Thread.currentThread();
            this.runThread.setName("Sequencer wait thread");
            long loopStart = System.nanoTime();
            int i = 0;
            while (true) {
                try {
                    long timeToWait;
                    long start = System.nanoTime();
                    int queueLength = 0;
                    boolean stopped = RebDevices.this.areSequencersStopped();
                    if (stopped) {
                        Runnable r;
                        while ((r = (Runnable)RebDevices.this.stoppedQueue.poll()) != null) {
                            r.run();
                        }
                        RebDevices.this.sequencerLock.lock();
                        try {
                            RebDevices.this.sequencerStopped.signalAll();
                            queueLength = 0;
                        }
                        finally {
                            RebDevices.this.sequencerLock.unlock();
                        }
                    }
                    if (queueLength == 0) {
                        RebDevices.this.sequencerLock.lock();
                        try {
                            queueLength = RebDevices.this.sequencerLock.getWaitQueueLength(RebDevices.this.sequencerStopped);
                        }
                        finally {
                            RebDevices.this.sequencerLock.unlock();
                        }
                    }
                    long nanosToWait = 1000000L;
                    while ((timeToWait = nanosToWait - (System.nanoTime() - start)) >= 0L) {
                        LockSupport.parkNanos(timeToWait);
                    }
                    if (i % 1000 == 0) {
                        long loopTime = System.nanoTime() - loopStart;
                        int q = queueLength;
                        int count = i;
                        LOG.log(Level.INFO, () -> String.format("RebDevices Loop %d: %,dns with queue length %d", count, loopTime, q));
                        loopStart = System.nanoTime();
                    }
                }
                catch (Throwable x) {
                    LOG.log(Level.SEVERE, "DAQ exception in REBDevices loop", x);
                }
                ++i;
            }
        }

        boolean waitSequencersStopped(Duration timeout) throws InterruptedException {
            RebDevices.this.sequencerLock.lock();
            try {
                LockSupport.unpark(this.runThread);
                boolean bl = RebDevices.this.sequencerStopped.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
                return bl;
            }
            finally {
                RebDevices.this.sequencerLock.unlock();
            }
        }
    }
}

