package org.lsst.ccs.subsystem.focalplane;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.focalplane.alerts.FocalPlaneAlertType;
import org.lsst.ccs.subsystem.rafts.REBDevice;

/**
 * An Alarm class for raising alerts specific to a given Reb.
 *
 * @author The LSST CCS Team
 */
public class FocalPlaneRebAlarm extends Alarm {

    @LookupField(strategy = LookupField.Strategy.ANCESTORS)
    REBDevice rebDevice;

    FocalPlaneAlertType alertType = null;
    
    public FocalPlaneRebAlarm() {
        super(null);
    }
    
    @Override
    public void build() {
        if ( rebDevice == null ) {
            throw new RuntimeException("A FocalPlaneRebAlarm must defined within a REBDevice.");
        }
        if ( alertType == null ) {
            throw new RuntimeException("An alert type must be specified.");
        }
        super.build();
        this.description = alertType.getDescription();
    }
    
    REBDevice getRebDevice() {
        return rebDevice;
    }

    @Override
    public Alert getAlert(AlertState alertState, AlertState previousAlertState) {
        Alert alert = new Alert(alertType.getAlertId()+"/"+rebDevice.getPath(),alertType.getDescription());
        //Add a RebPowerAction payload only if in ALARM state and if the temperatures are too high
        if ( alertType == FocalPlaneAlertType.ASPICS_TEMPERATURE_TOO_HIGH || alertType == FocalPlaneAlertType.REB_BOARD_TEMPERATURE_TOO_HIGH ) {
            if (alertState == AlertState.ALARM) {
                RebPowerAction.addRebPowerActionPayloadToAlert(alert, RebPowerAction.Type.TURN_REB_OFF, rebDevice.getPath());
            }
        }
        return alert;                
    }
    

}
