package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

/**
 * A CCSImageList is a play list backed by a simple ASCII text file.
 * Such playlists can be used both by CCSEmulatedPlayList or CCSSimulatedPlayList
 * @author tonyj
 */
public class CCSImageList {


    private final Path path;
    private final String dataFolder;
    private final String daqFolder;
    private final List<String> images;

    CCSImageList(Path path, String dataFolder, String daqFolder, List<String> images) {
        this.path = path;
        this.dataFolder = dataFolder;
        this.daqFolder = daqFolder;
        this.images = images;
    }
   
    void save() throws IOException {
        try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING))) {
            out.println(dataFolder);
            out.println(daqFolder);
            for (String image : images) {
                out.println(image);
            }  
        } 
    }
    
    int size() {
        return images.size();
    }
    
    void add(String image) {
        images.add(image);
    }
    
    static CCSImageList open(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path);
        String dataFolder = lines.get(0);
        String daqFolder = lines.get(1);
        List<String> imageList = lines.subList(2, lines.size());
        return new CCSImageList(path, dataFolder, daqFolder, imageList);
    }

    
    static CCSImageList create(Path playListPath, String dataFolder, String daqFolder) {
        List<String> imageList = new ArrayList<>();
        return new CCSImageList(playListPath, dataFolder, daqFolder, imageList);
    }    
    
    String getDAQFolder() {
        return daqFolder;
    }

    String getName() {
        return path.getFileName().toString();
    }

    String get(int index) {
        return images.get(index);
    }

    public String getDataFolder() {
        return dataFolder;
    }
   
}
