package org.lsst.ccs.subsystem.focalplane;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;

/**
 * A configurable service for fetching image names.
 *
 * @author tonyj
 */
@SuppressWarnings("FieldMayBeFinal")
public class ImageDatabaseService implements HasLifecycle {

    private static final Logger LOG = Logger.getLogger(ImageDatabaseService.class.getName());

    @ConfigurationParameter(isFinal = true, units="unitless", description="Image Database URL")
    private volatile String dbURL;
    
    @ConfigurationParameter(isFinal = true, units="unitless", description="true/false Image Database enable flag")
    private volatile boolean enabled = true;
    
    @LookupField(strategy = LookupField.Strategy.TREE)
    private InstrumentConfig instrumentConfig;
    
    /**
     * Create a test instance of the ImageDatabaseService
     * @param dbURL The dbURL to use
     * @return The created and initialized ImageNameService
     */
    public static ImageDatabaseService testInstance(String dbURL) {
        ImageDatabaseService idbs = new ImageDatabaseService();
        idbs.dbURL = dbURL;
        return idbs;
    }
    private ImageDatabase idb;

    @Override
    public void shutdown() {
        try {
            if (idb != null) {
                idb.close();
            }
        } catch (SQLException ex) {
            LOG.log(Level.SEVERE, "Error closeing image database", ex);
        }
    }

    public ImageDatabase getImageDatabase() {
        if (idb == null && enabled) {
            String testStand = instrumentConfig == null ? "NOT" : instrumentConfig.getTestStand();
            idb = new ImageDatabase(dbURL, testStand);
        }
        return idb;
    }

}
