/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.subsystem.focalplane.CCSImageList;
import org.lsst.ccs.subsystem.focalplane.CCSPlayList;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.imagehandling.data.TriggerSimulatedImage;
import org.lsst.ccs.utilities.location.LocationSet;

public class CCSSimulatedPlayList
extends CCSPlayList {
    private static final Logger LOG = Logger.getLogger(CCSSimulatedPlayList.class.getName());
    private final SequencerConfig config;
    private final FocalPlaneSubsystem subsys;
    private final String emulatedDAQFolder;
    private final String emulatedDataFolder;

    CCSSimulatedPlayList(CCSImageList imageList, boolean repeat, FocalPlaneSubsystem subsys, SequencerConfig config) throws DAQException, IOException {
        super(imageList, repeat);
        this.subsys = subsys;
        this.config = config;
        this.emulatedDAQFolder = imageList.getDAQFolder();
        this.emulatedDataFolder = imageList.getDataFolder();
    }

    @Override
    void play(String emulatedImageName, String triggeredImageName, LocationSet effectiveLocations, int opCode, String annotation) throws IOException, DAQException {
        TriggerSimulatedImage tsi = new TriggerSimulatedImage(triggeredImageName, this.config.getDAQFolder(), emulatedImageName, this.emulatedDAQFolder, this.emulatedDataFolder, effectiveLocations, opCode, annotation);
        this.subsys.sendEvent("triggerSimulatedImage", (Serializable)tsi);
    }
}

