/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.guider.ROICommon;
import org.lsst.ccs.daq.guider.ROISpec;
import org.lsst.ccs.daq.guider.Series;
import org.lsst.ccs.daq.guider.Status;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Guider;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.states.GuidingState;
import org.lsst.ccs.utilities.location.SensorLocationSet;

public class Guiding {
    private static final Logger LOG = Logger.getLogger(Guiding.class.getName());
    private final SequencerConfig sequencerConfig;
    private final AgentStateService agentStateService;
    private ROISpec roiSpec;
    private static final SensorLocationSet NO_SENSORS = new SensorLocationSet();

    public Guiding(SequencerConfig config, AgentStateService agentStateService) {
        this.sequencerConfig = config;
        this.agentStateService = agentStateService;
        boolean hasGuiderPartition = this.sequencerConfig.hasGuiderPartition();
        if (hasGuiderPartition) {
            try {
                this.updateState(this.sequencerConfig.getGuider().series().getStatus().getOut());
            }
            catch (DAQException x) {
                LOG.log(Level.SEVERE, "Error initializing guider state", x);
                agentStateService.updateAgentState(new Enum[]{GuidingState.UNDEFINED});
            }
        } else {
            agentStateService.updateAgentState(new Enum[]{GuidingState.UNDEFINED});
        }
    }

    private void updateState(Status.State state) {
        LOG.log(Level.INFO, "Initial guding state {0}", state);
        this.agentStateService.updateAgentState(new Enum[]{GuidingState.values()[state.ordinal()]});
    }

    void initGuiders(String roiSpec) throws DAQException {
        this.roiSpec = ROISpec.parse((String)roiSpec);
    }

    int validate(String roiSpec) throws DAQException {
        ROISpec spec = ROISpec.parse((String)roiSpec);
        Guider guider = this.sequencerConfig.getGuider();
        spec.sanityCheck(guider.getConfiguredLocations());
        ROICommon common = spec.getCommon();
        guider.validate(common, spec.getLocations());
        int rows = common.getRows();
        int cols = common.getCols();
        int ns = 32751760 + 490700 * rows + 1030 * cols * rows;
        return common.getIntegrationTimeMillis() + ns / 1000000;
    }

    void startGuiding(String imageName) throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        Series series = guider.series();
        Status.State out = series.getStatus().getOut();
        if (out == Status.State.OFF) {
            guider.wake();
        }
        guider.start(this.roiSpec.getCommon(), imageName, this.roiSpec.getLocations());
        guider.resume();
        this.agentStateService.updateAgentState(new Enum[]{GuidingState.RUNNING});
    }

    int stopGuiding() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        guider.pause();
        int stamps = guider.series().getStamps();
        guider.stop();
        this.agentStateService.updateAgentState(new Enum[]{GuidingState.STOPPED});
        return stamps;
    }

    boolean isROISet() {
        return this.roiSpec != null;
    }

    void clearROI() {
        this.roiSpec = null;
    }

    SensorLocationSet getSensors() {
        return this.roiSpec == null ? NO_SENSORS : this.roiSpec.getSensorLocations();
    }

    void sleepGuider() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        guider.sleep();
        this.agentStateService.updateAgentState(new Enum[]{GuidingState.OFF});
    }
}

