package org.lsst.ccs.subsystem.focalplane;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.MonitorUpdateTask;

/**
 * Commands that are used to pause/resume/trigger monitoring.
 *
 * @author The LSST CCS Team
 */
public class MonitoringCommands {

    private final MonitoringConfig config;

    MonitoringCommands(MonitoringConfig config) {
        this.config = config;
    }

    @Command(description = "Print the list of tasks that will be paused during readout", type = Command.CommandType.QUERY, level = 0)
    public String printTasksToPauseDuringReadout() {
        return config.printTasksToPauseDuringReadout();
    }
    
    @Command(description = "Print the list of tasks that will be triggered after readout", type = Command.CommandType.QUERY, level = 0)
    public String printTasksToTriggerAfterReadout() {
        return config.printTasksToTriggerAfterReadout();
    }
    
    @Command(description = "Pause monitoring tasks", type = Command.CommandType.ACTION, level = 0)
    public void pauseMonitoringTasks() {
        config.pauseMonitoringTasks();
    }

    @Command(description = "Resume monitoring tasks", type = Command.CommandType.ACTION, level = 0)
    public void resumeMonitoringTasks() {
        config.resumeMonitoringTasks();
    }
    
    @Command(description = "Trigger monitoring tasks", type = Command.CommandType.ACTION, level = 0)
    public void triggerMonitoringTasks() {
        config.triggerMonitoringTasks();
    }

}
