package org.lsst.ccs.subsystem.focalplane;

import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

/**
 *
 * @author tonyj
 */
public class ConfigListener implements ConfigurationListener {

    private final FocalPlaneSubsystem subsys;
    private static final Logger LOG = Logger.getLogger(ConfigListener.class.getName());

    public ConfigListener(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    @Override
    public void configurationChanged(ConfigurationInfo newConfigurationInfo, ConfigurationInfo oldConfigurationInfo, ConfigurationOperation configOperation) {
        // These are the changes between new and old configuration.
        List<ConfigurationParameterInfo> latestChanges = newConfigurationInfo.diff(oldConfigurationInfo);
        if (!latestChanges.isEmpty()) {
            boolean sequencerChanged = false;
            boolean sequencerParameterChanged = false;
            boolean aspicChanged = false;
            boolean idleFlushChanged = false;

            for (ConfigurationParameterInfo change : latestChanges) {
                if ("sequencer".equals(change.getParameterName())) {
                    sequencerChanged = true;
                } else if ("idleFlushTimeout".equals(change.getParameterName())) {
                    idleFlushChanged = true;
                } else if ("Sequencer".equals(change.getCategoryName())) {
                    sequencerParameterChanged = true;
                } else if (change.getPathName().contains("ASPIC")) {
                    aspicChanged = true;
                }
            }
            if (sequencerChanged) {
                LOG.info("Sequencer config changed, reloading...");
                subsys.loadSequencers();
            } else if (sequencerParameterChanged) {
                LOG.info("Sequencer parameters changed, reloading...");
                subsys.loadSequencerParameters();
            }
            if (aspicChanged) {
                LOG.info("ASPIC config changed, reloading...");
                subsys.loadASPICS();
            }
        }
    }
}
