/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public final class BooleanValue
extends AtomicValue
implements Comparable {
    private boolean value;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$BooleanValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    private BooleanValue(boolean bl) {
        this.value = bl;
    }

    public static BooleanValue get(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static AtomicValue fromString(CharSequence charSequence) {
        if ((charSequence = ((Object)BooleanValue.trimWhitespace(charSequence)).toString()).equals("true") || charSequence.equals("1")) {
            return TRUE;
        }
        if (charSequence.equals("false") || charSequence.equals("0")) {
            return FALSE;
        }
        ValidationException validationException = new ValidationException("The string " + Err.wrap(charSequence, 4) + " cannot be cast to a boolean");
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 514: 
            case 643: {
                return this;
            }
            case 532: 
            case 646: {
                return new IntegerValue(this.value ? 1L : 0L);
            }
            case 515: 
            case 516: 
            case 517: {
                return new IntegerValue(this.value ? 1L : 0L).convertPrimitive(builtInAtomicType, bl, xPathContext);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert boolean to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return this.value ? "true" : "false";
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = BooleanValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$BooleanValue == null ? (class$net$sf$saxon$value$BooleanValue = BooleanValue.class$("net.sf.saxon.value.BooleanValue")) : class$net$sf$saxon$value$BooleanValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return this.value;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return this.value;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = BooleanValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = BooleanValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE) {
            return new Double(this.value ? 1 : 0);
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = BooleanValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value ? 1 : 0);
        }
        if (clazz == Float.TYPE) {
            return new Float(this.value ? 1 : 0);
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = BooleanValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value ? 1 : 0);
        }
        if (clazz == Long.TYPE) {
            return new Long(this.value ? 1 : 0);
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = BooleanValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(this.value ? 1 : 0);
        }
        if (clazz == Integer.TYPE) {
            return new Integer(this.value ? 1 : 0);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = BooleanValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(this.value ? 1 : 0);
        }
        if (clazz == Short.TYPE) {
            return new Short((short)(this.value ? 1 : 0));
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = BooleanValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)(this.value ? 1 : 0));
        }
        if (clazz == Byte.TYPE) {
            return new Byte((byte)(this.value ? 1 : 0));
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = BooleanValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)(this.value ? 1 : 0));
        }
        if (clazz == Character.TYPE) {
            return new Character(this.value ? (char)'1' : '0');
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = BooleanValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character(this.value ? (char)'1' : '0');
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of boolean to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SAXON:0000");
            throw dynamicError;
        }
        return object;
    }

    public int compareTo(Object object) {
        if (!(object instanceof BooleanValue)) {
            throw new ClassCastException("Boolean values are not comparable to " + object.getClass());
        }
        if (this.value == ((BooleanValue)object).value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BooleanValue)) {
            throw new ClassCastException("Boolean values are not comparable to " + object.getClass());
        }
        return this.value == ((BooleanValue)object).value;
    }

    public int hashCode() {
        return this.value ? 0 : 1;
    }

    public String toString() {
        return this.getStringValue() + "()";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

