/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.readout;

import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.readout.ReadOutRegisterMap;

public abstract class ReadOutParameters {
    private final int[] registers;
    private final CCDType ccdType;
    private final ReadOutRegisterMap registerMap;

    ReadOutParameters(CCDType ccdType, int[] registers, ReadOutRegisterMap registerMap) {
        this.registers = registers;
        this.ccdType = ccdType;
        this.registerMap = registerMap;
    }

    public CCDType getCCDType() {
        return this.ccdType;
    }

    public final int getValue(String parameterName) {
        return this.registers[this.registerMap.getIndex(parameterName)];
    }

    public abstract int getSerialReadPixels();

    public abstract int getParallelReadPixels();

    public abstract int getTotalParallelSize();

    public abstract int getTotalSerialSize();

    public abstract int getSerialPrescan();

    abstract void validate();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String name : this.registerMap.getNames()) {
            builder.append(name).append("=").append(this.getValue(name)).append(";");
        }
        return builder.toString();
    }
}

