/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Emulator;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Playlist;

class CCSPlayList {
    private static final Logger LOG = Logger.getLogger(CCSPlayList.class.getName());
    private final String name;
    private final List<Image> imageList;
    private final boolean repeat;
    private int index;
    private final Emulator emulator;
    private final Path tempFile;

    CCSPlayList(String playListFileName, List<Image> images, boolean repeat, Emulator emulator) throws IOException {
        this.name = playListFileName;
        this.imageList = images;
        this.repeat = repeat;
        this.index = 0;
        this.emulator = emulator;
        this.tempFile = Files.createTempFile("play", "list", new FileAttribute[0]);
    }

    String getName() {
        return this.name;
    }

    boolean hasNextImage() {
        return this.index < this.imageList.size();
    }

    Image peekNextImage() {
        return this.hasNextImage() ? this.imageList.get(this.index) : null;
    }

    void playNextImage() throws IOException, DAQException {
        if (!this.hasNextImage()) {
            throw new IOException("Playlist exhausted " + this);
        }
        Image currentImage = this.imageList.get(this.index++);
        if (this.index >= this.imageList.size() && this.repeat) {
            this.index = 0;
        }
        Files.deleteIfExists(this.tempFile);
        try (Playlist oneImagePlaylist = this.emulator.openPlaylist(this.tempFile.toFile());){
            LOG.log(Level.INFO, "Created temp playlist {0} with image {1}", new Object[]{this.tempFile, currentImage.getMetaData().getName()});
            oneImagePlaylist.add(currentImage);
            List images = oneImagePlaylist.getImages();
            LOG.log(Level.INFO, "Starting temp playlist {0} with image list {1}", new Object[]{this.tempFile, images});
            oneImagePlaylist.start(false);
        }
    }

    public String toString() {
        Image next = this.peekNextImage();
        return "CCSPlayList{name=" + this.name + ", index=" + this.index + ", size=" + this.imageList.size() + ", repeat=" + this.repeat + ", nextImage=" + (next == null ? "None" : this.peekNextImage().getMetaData().getName()) + '}';
    }
}

