/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ConfigurationDAOWrapper;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationLoadedData;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class ConfigurationService
implements ServiceLifecycle,
AgentPresenceListener,
AgentService,
HasDataProviderInfos,
HasLifecycle {
    private static final Logger conf_sub_log = Logger.getLogger(ConfigurationService.class.getName());
    private static final Alert CS_ALERT_1 = new Alert("CCSCFGSRV", "configuration service unavailable");
    private static final Alert CS_ALERT_2 = new Alert("CCSCFGOP", "operator error");
    private ConfigurationDAOWrapper configurationDao;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, ComponentConfigurationEnvironment> keyEnvironmentMap = new HashMap<String, ComponentConfigurationEnvironment>();
    private String descriptionName;
    private String agentName;
    private ConfigurationView groovyView = null;
    private boolean saveInitialConfiguration = false;
    private boolean migrateConfigurationFiles = false;
    private String printConfigurationParameters = null;
    private final Map<String, Serializable> configurationDataAttributes = new HashMap<String, Serializable>();
    private boolean publishChecksum = false;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MessagingService messagingService;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();
    private ConfigurationInfo currentConfigInfo;
    ConfigurationHandlerSet configurationHandler;
    private ConfigurationView currentView;
    private ConfigurationDescription defaultInitialDescription = null;
    private ConfigurationDescription requestedDescription = null;
    private ConfigurationView initialView;
    private boolean canGoToConfigured = false;
    private final boolean testContext = System.getProperty("org.lsst.ccs.testcontext", "false").equals("true");
    private final List<ConfigurationListener> configurationListeners = new CopyOnWriteArrayList<ConfigurationListener>();
    private String userProvidedConfiguration = null;
    private final ConfigurationLoadedData loadedData = new ConfigurationLoadedData();

    @Override
    public String getAgentServiceName() {
        return "configurationService";
    }

    public static Properties getBuildProperties(String descriptionName, String initialConfig) {
        try (ConfigurationDAOWrapper configurationProxy = new ConfigurationDAOWrapper(descriptionName);){
            Properties properties = ConfigurationService.getBuildProperties(configurationProxy, initialConfig);
            return properties;
        }
    }

    private static Properties getBuildProperties(ConfigurationDAOWrapper dao, String initialConfig) {
        ConfigurationDescription inputDescription = new ConfigurationDescription(Collections.singleton("build")).withDefaultInitial(true);
        if ((initialConfig = SubstitutionTokenUtils.resolveSubstitutionTokens((String)initialConfig)) != null) {
            inputDescription.parseConfigurationString(initialConfig.split(","));
        }
        Properties res = new Properties();
        Properties inputProperties = BootUtils.getInputBuildProperties();
        if (inputProperties != null) {
            res = inputProperties;
        }
        for (SingleCategoryTag tag : inputDescription.getCategoryTag("build").getSingleCategoryTags()) {
            res.putAll((Map<?, ?>)dao.getConfigurationProperties(tag));
        }
        return res;
    }

    public Properties getBuildProperties() {
        return ConfigurationService.getBuildProperties(this.configurationDao, this.userProvidedConfiguration);
    }

    @Override
    public void shutdown() {
        if (this.configurationDao != null) {
            this.configurationDao.close();
        }
    }

    @Override
    public void preBuild() {
        Properties bootProps;
        if (this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            this.configurationDataAttributes.put("type", (Serializable)((Object)"configuration-data-checksum"));
            this.publishChecksum = true;
        }
        if (!(bootProps = BootstrapResourceUtils.getBootstrapSystemProperties()).getOrDefault((Object)"org.lsst.ccs.config.remote", "false").equals("false")) {
            this.agentPropertiesService.setAgentProperty("org.lsst.ccs.config.remote", bootProps.getProperty("org.lsst.ccs.config.remote"));
        }
        this.userProvidedConfiguration = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("startupConfig");
        if (this.userProvidedConfiguration != null && this.userProvidedConfiguration.isEmpty()) {
            this.userProvidedConfiguration = null;
            conf_sub_log.log(Level.WARNING, "The empty String is no longer supported as a valid input for the --initialConfiguration option.\nPlease remove it or provide an explicit category tag to load.");
        }
        String migrateConfigurationFilesStr = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("migrateConfigurationFiles");
        this.migrateConfigurationFiles = "true".equals(migrateConfigurationFilesStr);
        String saveInitialConfigurationStr = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("saveInitialConfiguration");
        this.saveInitialConfiguration = "true".equals(saveInitialConfigurationStr);
        this.printConfigurationParameters = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("printConfigurationParameters");
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode configServiceNode = lookup.getComponentNodeForObject((Object)this);
        this.descriptionName = this.agent.getDescription();
        this.agentName = this.agent.getName();
        this.configurationDao = new ConfigurationDAOWrapper(this.descriptionName, this);
        lookup.addComponentNodeToLookup(configServiceNode, new ComponentNode("configurationDAO", (Object)this.configurationDao));
        this.currentView = this.initialView = this.scanTreeAndBuildInitialView(true);
        ConfigurationView userProvided = this.buildUserProvidedConfigurationView(true);
        this.initialView.putAll(userProvided);
        if (this.hasBuildParameters()) {
            this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, userProvided, this.agentName, true, true);
            this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD, false);
        }
    }

    private ConfigurationView buildUserProvidedConfigurationView(boolean isBuild) {
        String[] providedConfs;
        this.categories.clear();
        this.categories.addAll(this.configurationHandler.getCategorySet());
        this.defaultInitialDescription = new ConfigurationDescription(this.categories).withDefaultInitial(true);
        if (this.userProvidedConfiguration != null) {
            this.defaultInitialDescription.parseConfigurationString(this.userProvidedConfiguration.split(","));
        }
        ConfigurationView userProvidedConfigurationView = this.groovyView != null ? this.groovyView : new ConfigurationView();
        Set<Object> categoriesToLoad = new HashSet();
        ConfigurationDescription startupDescription = null;
        String[] stringArray = providedConfs = this.userProvidedConfiguration != null ? this.userProvidedConfiguration.split(",") : new String[]{};
        if (isBuild) {
            if (this.hasBuildParameters()) {
                categoriesToLoad.add("build");
                startupDescription = new ConfigurationDescription(categoriesToLoad).withDefaultInitial(true);
                for (String conf : providedConfs) {
                    if (!conf.contains("build")) continue;
                    startupDescription = startupDescription.parseConfigurationString(new String[]{conf});
                }
            }
        } else {
            categoriesToLoad = this.categories;
            if (this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
                startupDescription = new ConfigurationDescription(categoriesToLoad);
                for (String conf : providedConfs) {
                    if (conf.contains("build") && !this.hasBuildParameters()) continue;
                    startupDescription = startupDescription.parseConfigurationString(new String[]{conf});
                }
                startupDescription = startupDescription.withDefaultInitial(true);
            }
        }
        ConfigurationDescription loadedDescription = this.defaultInitialDescription.cloneForCategories(this.categories);
        if (startupDescription != null) {
            this.defaultInitialDescription = startupDescription.cloneForCategories(this.categories);
            ConfigurationLoadedData lastLoad = this.configurationDao.initialLoadConfiguration(startupDescription, !this.saveInitialConfiguration);
            ConfigurationView additionalUserProvidedConfigurationView = lastLoad.getConfigurationView();
            this.loadedData.putConfigurationLoadedData(lastLoad);
            userProvidedConfigurationView.putAll(additionalUserProvidedConfigurationView);
            loadedDescription = userProvidedConfigurationView.getConfigurationDescription();
        }
        if (userProvidedConfigurationView.getConfigurationDescription() == null) {
            userProvidedConfigurationView.setConfigurationDescription(loadedDescription);
        }
        this.requestedDescription = this.defaultInitialDescription.cloneForCategories(this.categories);
        return userProvidedConfigurationView;
    }

    @Override
    public void preInit() {
        ClearAlertHandler configurationServiceClearAlertHadler = new ClearAlertHandler(){

            @Override
            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                if (CS_ALERT_1.getAlertId().equals(alert.getAlertId())) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                if (CS_ALERT_2.getAlertId().equals(alert.getAlertId())) {
                    return ConfigurationService.this.stateService.isInState((Enum)ConfigurationState.CONFIGURED) ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
            }
        };
        this.alertService.registerAlert(CS_ALERT_1, configurationServiceClearAlertHadler);
        this.alertService.registerAlert(CS_ALERT_2, configurationServiceClearAlertHadler);
        this.currentView = this.initialView = this.scanTreeAndBuildInitialView(false);
        ConfigurationView userProvided = this.buildUserProvidedConfigurationView(false);
        this.initialView.putAll(userProvided);
        this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, userProvided, this.agentName, false, true);
        this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD);
        if (this.saveInitialConfiguration) {
            this.saveChanges();
            System.exit(0);
        }
        if (this.migrateConfigurationFiles) {
            this.configurationDao.close();
            System.exit(0);
        }
        if (this.printConfigurationParameters != null) {
            Properties buildProps;
            String[] cats;
            HashSet<String> printCats = new HashSet<String>();
            if (!this.printConfigurationParameters.isEmpty() && (cats = this.printConfigurationParameters.split(",")).length > 0) {
                for (String c : cats) {
                    if (this.categories.contains(c = c.trim())) {
                        printCats.add(c);
                        continue;
                    }
                    System.out.println("Invalid category " + c + ". Allowed values are " + this.categories);
                }
            }
            if (printCats.isEmpty()) {
                printCats.addAll(this.categories);
            }
            if (!(buildProps = this.getBuildProperties()).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Object prop : buildProps.keySet()) {
                    try {
                        ParameterPath path = ParameterPath.valueOf((String)((String)prop));
                        try {
                            if (this.getParameterByPath(path).isBuild()) {
                                continue;
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    sb.append(prop).append(" = ").append(buildProps.getProperty((String)prop)).append("\n");
                }
                if (!sb.toString().isEmpty()) {
                    System.out.println("\nBuild Properties: \n" + sb.toString());
                }
            }
            String[] toPrint = new String[printCats.size()];
            toPrint = printCats.toArray(toPrint);
            System.out.println();
            System.out.println(this.printConfigurationParameters(toPrint));
            System.exit(0);
        }
    }

    ConfigurationView getCurrentConfigurationView() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = new ConfigurationView(this.currentView);
            return configurationView;
        }
    }

    private boolean hasBuildParameters() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            for (String category : this.categories) {
                CategoryHandler categoryHandler = this.configurationHandler.getCategoryHandler(category);
                for (ConfigurationParameterHandler cph : categoryHandler.getParameters()) {
                    if (!cph.isBuild()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    private ConfigurationView scanTreeAndBuildInitialView(boolean isBuild) {
        boolean checkConfigViews = this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0;
        boolean failOnViewProblems = checkConfigViews && !this.saveInitialConfiguration;
        this.configurationHandler = new ConfigurationHandlerSet(checkConfigViews, failOnViewProblems);
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode topNode = lookup.getTopComponentNode();
        TreeWalkerUtils.proceduralNodeWalk(lookup, null, n -> {
            String nodeName = n.getPath();
            Object component = n.getComponent();
            ConfigurationHandler ch = this.configurationHandler.addConfigurationHandlerForObject(nodeName, n.getPath(), component);
            if (ch != null && !isBuild && ch.hasRuntimeParameters()) {
                ComponentConfigurationEnvironment cce = new ComponentConfigurationEnvironment(nodeName, this);
                this.keyEnvironmentMap.put(nodeName, cce);
                this.agentCommandDictionaryService.addCommandSetToObject(cce, n.getPath());
            }
        }, null);
        ConfigurationView initialView = new ConfigurationView();
        initialView.putAll(this.configurationHandler.getLiveConfigurationView());
        if (this.groovyView == null) {
            this.groovyView = new ConfigurationView();
            String agentPrefix = this.agent.getName() + "/";
            Map topNodeTags = topNode.getTags();
            for (Map.Entry entry : topNodeTags.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                try {
                    ParameterPath path;
                    Object nodeObj;
                    String value = TypeUtils.stringify(entry.getValue());
                    String parPath = (String)entry.getKey();
                    if (parPath.startsWith(agentPrefix) && !(parPath = parPath.replace(agentPrefix, "")).contains("/")) {
                        parPath = "/" + parPath;
                    }
                    if ((nodeObj = lookup.getComponentByPath((path = ParameterPath.valueOf((String)parPath)).getComponentName())) == null) continue;
                    String componentPath = lookup.getComponentNodeForObject(nodeObj).getPath();
                    if (this.isParameterConfigurable(componentPath, (path = new ParameterPath(componentPath, path.getParameterName())).getParameterName())) {
                        this.groovyView.putParameterValue(path.toString(), value);
                        continue;
                    }
                    throw new RuntimeException("Not configurable " + path + " " + parPath);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        initialView.putAll(this.groovyView);
        return initialView;
    }

    @Override
    public void preStart() {
        this.canGoToConfigured = true;
        if (this.currentConfigInfo.getConfigurationState() != ConfigurationState.CONFIGURED) {
            this.currentConfigInfo.setConfigurationState(ConfigurationState.CONFIGURED);
            try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
                this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD);
            }
        }
        this.messagingService.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    @Override
    public List<DataProviderInfo> getDataProviderInfos() {
        List dataList = this.configurationHandler.getDataPoviderInfoList();
        if (this.publishChecksum) {
            for (String category : this.categories) {
                DataProviderInfo data = new DataProviderInfo("config/data/" + category + "/checksum", DataProviderInfo.Type.TRENDING, "config/data/" + category + "/checksum");
                data.addAttribute(DataProviderInfo.Attribute.UNITS, "unitless");
                data.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Configuration data checksum for category " + category);
                data.addAttribute(DataProviderInfo.Attribute.DO_NOT_TREND, "true");
                dataList.add(data);
            }
        }
        return dataList;
    }

    @Override
    public void publishDataProviderCurrentData(AgentInfo ... agents) {
        this.publishConfigurationInfo();
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String getConfigurationParameterValue(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName) {
        this.verifyInputComponentName(componentName);
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        Map values = view.getValuesForComponent(componentName);
        if (!values.containsKey(parameterName)) {
            throw new IllegalArgumentException("Parameter " + parameterName + " does not exist for component " + componentName);
        }
        return (String)view.getValuesForComponent(componentName).get(parameterName);
    }

    private void verifyInputComponentName(String componentName) {
        if (!this.getAllConfigurableComponents().contains(componentName)) {
            throw new IllegalArgumentException("Component " + componentName + " does not exist.");
        }
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String printConfigurationParameters(String ... categories) {
        return this.printConfigParameters(null, false, categories);
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String printDirtyConfigurationParameters(String ... categories) {
        return this.printConfigParameters(null, true, categories);
    }

    String printConfigParameters(String component, boolean dirtyOnly, String ... inputCategories) {
        this.verifyInputCategories(inputCategories);
        StringBuilder sb = new StringBuilder();
        HashSet<String> cats = new HashSet<String>();
        if (inputCategories != null) {
            cats.addAll(Arrays.asList(inputCategories));
        }
        Set<String> categorySet = this.getCategories();
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
            for (String category : categorySet) {
                if (!cats.isEmpty() && !cats.contains(category)) continue;
                boolean printCategory = true;
                CategoryHandler catHandler = this.configurationHandler.getCategoryHandler(category);
                for (ConfigurationParameterHandler par : catHandler.getParameters()) {
                    ParameterPath path = par.getParameterPath();
                    if (component != null && !path.getComponentName().equals(component)) continue;
                    ConfigurationParameterInfo cpi = this.getConfigurationInfo().getCurrentParameterInfo(path.toString());
                    if (dirtyOnly && !cpi.isDirty()) continue;
                    if (printCategory) {
                        sb.append("Category : ").append(category).append("\n");
                        printCategory = false;
                    }
                    String configType = par.isFinal() ? "final" : (par.isBuild() ? "build" : (par.isReadOnly() ? "read-only" : ""));
                    sb.append(path.getComponentName()).append(" ").append(path.getParameterName()).append(cpi.isDirty() ? "*" : "").append(" ").append(view.getPathValue(path)).append(" ").append(par.getUnits()).append(configType.isEmpty() ? "" : " (" + configType + ")");
                    sb.append("\n");
                }
                if (sb.toString().isEmpty()) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String printConfigParameters(boolean dirtyOnly, String ... inputCategories) {
        return this.printConfigParameters(null, dirtyOnly, inputCategories);
    }

    private void verifyInputCategories(String ... categories) {
        List<String> existingCategories = this.getCategoriesList();
        for (String inputCategory : categories) {
            if (existingCategories.contains(inputCategory)) continue;
            throw new IllegalArgumentException("Input category \"" + inputCategory + "\" is invalid.");
        }
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void saveChanges() {
        this.saveChangesForCategoriesInternal(false, this.categories.toArray(new String[1]));
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void saveFullConfiguration() {
        this.saveChangesForCategoriesInternal(true, this.categories.toArray(new String[1]));
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void saveChangesForCategories(String ... categoryTags) {
        this.saveChangesForCategoriesInternal(false, categoryTags);
    }

    @Deprecated
    public void saveChangesForCategoriesAs(String ... categoryTags) {
        this.saveChangesForCategories(categoryTags);
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void saveFullConfigurationForCategories(String ... categoryTags) {
        this.saveChangesForCategoriesInternal(true, categoryTags);
    }

    private List<CategoryDescription> convertInputCategoryTags(boolean isSave, String ... categories) {
        ConfigurationDescription currentDescription = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo);
        ArrayList<CategoryDescription> res = new ArrayList<CategoryDescription>();
        for (String category : categories) {
            CategoryDescription categoryTag = null;
            String tmpCategory = category;
            if (!category.contains(":")) {
                if (this.categories.contains(tmpCategory)) {
                    categoryTag = new CategoryDescription(tmpCategory);
                    if (isSave) {
                        CategoryDescription currentCatDescription = currentDescription.getCategoryTag(tmpCategory);
                        categoryTag = new CategoryDescription(tmpCategory);
                        for (SingleCategoryTag singleTag : currentCatDescription.getSingleCategoryTags()) {
                            if (this.defaultInitialDescription.getCategoryTag(tmpCategory).containsSingleTag(singleTag)) continue;
                            categoryTag.addOrUpdadateSingleTag(singleTag);
                        }
                    }
                } else {
                    tmpCategory = ":" + category;
                }
            }
            if (tmpCategory.contains(":")) {
                categoryTag = CategoryDescription.parseCategoryTagInput((String)tmpCategory);
                if (isSave && categoryTag.getSingleCategoryTags().size() > 1) {
                    throw new IllegalArgumentException("When saving configurations we accept only one tag. Illegal input: " + categoryTag);
                }
            }
            String cat = categoryTag.getCategoryName();
            CategoryDescription categoryDescription = this.defaultInitialDescription.getCategoryTag(cat);
            CategoryDescription newCategoryTag = new CategoryDescription(cat);
            if (categoryDescription != null) {
                for (SingleCategoryTag tag : categoryTag.getSingleCategoryTags()) {
                    if (!categoryDescription.containsSingleTag(tag)) continue;
                    throw new IllegalArgumentException("Invalid input category tag: " + tag + "\nIt's already defined in the initial category description: " + this.defaultInitialDescription.getCategoryTag(cat));
                }
                newCategoryTag.merge(categoryDescription);
            }
            newCategoryTag.merge(categoryTag);
            res.add(newCategoryTag);
        }
        return res;
    }

    private void saveChangesForCategoriesInternal(boolean fullConfiguration, String ... taggedCategories) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkForSubmittedChanges();
            ConfigurationDescription configDesc = new ConfigurationDescription();
            List<CategoryDescription> confDescriptions = this.convertInputCategoryTags(true, taggedCategories);
            for (CategoryDescription confDescription : confDescriptions) {
                configDesc.addCategoryTag(confDescription);
            }
            this.checkValidStates(true);
            if (configDesc.isEmpty()) {
                return;
            }
            this.checkCategories(configDesc.getCategoriesSet());
            try {
                ConfigurationView currentView = this.configurationHandler.getLiveConfigurationView();
                ConfigurationView diff = this.extractConfigurationViewFromCurrentConfigurationInfo().diff(currentView);
                if (!diff.isEmpty()) {
                    StringBuilder sb = new StringBuilder("the following parameters have had their value changed without notifying the configuration service : \n");
                    for (ParameterPath parm : diff.getAsParameterPathMap().keySet()) {
                        sb.append(parm).append(" expected ").append(this.currentConfigInfo.getCurrentValueForParameter(parm.toString())).append(" was ").append(currentView.getPathValue(parm)).append("\n");
                    }
                    throw new BulkSettingException(sb.toString());
                }
                currentView.setConfigurationDescription(configDesc);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(currentView);
                ConfigurationInfo ci = ciBuilder.build();
                ConfigurationDescription desc = this.configurationDao.saveChangesForCategoriesAs(configDesc, ci, fullConfiguration);
                this.updateStateAndSendStatusConfigurationInfo(ci, ConfigurationListener.ConfigurationOperation.SAVE);
                this.requestedDescription = new ConfigurationDescription(this.categories).merge(this.defaultInitialDescription).merge(configDesc);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.SAVE);
            }
        }
    }

    private ConfigurationDescription getPartialConfigurationDescription(String ... categories) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(categories));
        return ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo, set);
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropAllChanges() {
        this.dropChangesInternal(this.categories);
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropChangesForCategories(String ... categories) {
        HashSet<String> catSet = new HashSet<String>();
        catSet.addAll(Arrays.asList(categories));
        this.dropChangesInternal(catSet);
    }

    private void dropChangesInternal(Set<String> categories) {
        StringBuilder sb = new StringBuilder("List of dropped changes by category.\n");
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            this.checkCategories(categories);
            try {
                ConfigurationView view = new ConfigurationView(this.getPartialConfigurationDescription(categories.toArray(new String[1])));
                HashMap<String, List> droppedChangesByCategory = new HashMap<String, List>();
                for (ConfigurationParameterInfo cpi : this.currentConfigInfo.getAllParameterInfo()) {
                    if (!categories.contains(cpi.getCategoryName())) continue;
                    String currentValue = cpi.getCurrentValue();
                    String configuredValue = cpi.getConfiguredValue();
                    if (currentValue != null && !currentValue.equals(configuredValue) || currentValue == null && configuredValue != null) {
                        droppedChangesByCategory.computeIfAbsent(cpi.getCategoryName(), k -> new ArrayList()).add(cpi);
                    }
                    view.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getConfiguredValue());
                }
                for (String category : categories) {
                    List droppedForCategory = (List)droppedChangesByCategory.get(category);
                    if (droppedForCategory == null || droppedForCategory.isEmpty()) continue;
                    sb.append("\nCategory: ").append(category).append("\n");
                    for (ConfigurationParameterInfo cpi : droppedForCategory) {
                        sb.append("\t").append(cpi.getPathName()).append(": ").append(cpi.getCurrentValue()).append(" --> ").append(cpi.getConfiguredValue()).append("\n");
                    }
                }
                ConfigurationView res = this.configurationHandler.loadCategories(view);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.DROP);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.DROP);
            }
        }
        conf_sub_log.log(Level.INFO, sb.toString());
    }

    @Command(name="loadAllCategories", description="loads a new configuration", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=0)
    public void loadConfiguration(String ... taggedCategories) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(false);
            this.checkForSubmittedChanges();
            ConfigurationDescription res = new ConfigurationDescription();
            res.merge(this.defaultInitialDescription);
            ConfigurationDescription in = new ConfigurationDescription();
            List<CategoryDescription> confDescriptions = this.convertInputCategoryTags(false, taggedCategories);
            for (CategoryDescription confDescription : confDescriptions) {
                in.addCategoryTag(confDescription);
            }
            res.merge(in);
            this.loadCategoriesInternal(res);
        }
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void loadCategories(String ... taggedCategories) {
        if (taggedCategories.length == 0) {
            return;
        }
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            this.checkForSubmittedChanges();
            ConfigurationDescription res = new ConfigurationDescription();
            List<CategoryDescription> confDescriptions = this.convertInputCategoryTags(false, taggedCategories);
            for (CategoryDescription confDescription : confDescriptions) {
                res.addCategoryTag(confDescription);
            }
            this.loadCategoriesInternal(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCategoriesInternal(ConfigurationDescription configDesc) {
        Exception exception;
        ConfigurationView loadedView;
        block11: {
            this.checkCategories(configDesc.getCategoriesSet());
            ConfigurationView view = this.currentView;
            loadedView = null;
            exception = null;
            try {
                ConfigurationLoadedData lastLoad = this.configurationDao.loadConfiguration(configDesc);
                loadedView = lastLoad.getConfigurationView();
                if (this.testContext) {
                    for (String category : configDesc.getCategoriesSet()) {
                        for (ConfigurationParameterHandler cph : this.getCategoryParameters(category)) {
                            ParameterPath parPath = cph.getParameterPath();
                            if (loadedView.containsPath(parPath)) continue;
                            loadedView.putParameterValue(parPath.toString(), this.getInitialView().getPathValue(parPath));
                        }
                    }
                }
                loadedView = this.configurationHandler.loadCategories(loadedView);
                this.requestedDescription = new ConfigurationDescription(this.categories).merge(this.defaultInitialDescription).merge(configDesc);
                this.loadedData.putConfigurationLoadedData(lastLoad);
                if (exception == null) break block11;
                conf_sub_log.log(Level.WARNING, "Rolling back to previously loaded configuration: {0}", view.getConfigurationDescription().getDescriptionName());
                this.dropAllSubmittedChanges();
            }
            catch (Exception e) {
                block12: {
                    try {
                        exception = e;
                        conf_sub_log.log(Level.WARNING, "Failed to load configuration " + configDesc.getDescriptionName(), e);
                        this.notifyConfigurationListeners(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD, e);
                        if (exception == null) break block12;
                        conf_sub_log.log(Level.WARNING, "Rolling back to previously loaded configuration: {0}", view.getConfigurationDescription().getDescriptionName());
                        this.dropAllSubmittedChanges();
                    }
                    catch (Throwable throwable) {
                        if (exception != null) {
                            conf_sub_log.log(Level.WARNING, "Rolling back to previously loaded configuration: {0}", view.getConfigurationDescription().getDescriptionName());
                            this.dropAllSubmittedChanges();
                            loadedView = this.configurationHandler.loadCategories(view);
                            loadedView.setConfigurationDescription(new ConfigurationDescription());
                        }
                        ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(loadedView);
                        this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.LOAD);
                        if (exception != null) {
                            this.handleException((RuntimeException)((Object)new ConfigurationServiceException("Failed Loading " + configDesc.getDescriptionName(), (Throwable)exception)), ConfigurationListener.ConfigurationOperation.LOAD);
                        }
                        throw throwable;
                    }
                    loadedView = this.configurationHandler.loadCategories(view);
                    loadedView.setConfigurationDescription(new ConfigurationDescription());
                }
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(loadedView);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.LOAD);
                if (exception != null) {
                    this.handleException((RuntimeException)((Object)new ConfigurationServiceException("Failed Loading " + configDesc.getDescriptionName(), (Throwable)exception)), ConfigurationListener.ConfigurationOperation.LOAD);
                }
            }
            loadedView = this.configurationHandler.loadCategories(view);
            loadedView.setConfigurationDescription(new ConfigurationDescription());
        }
        ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(loadedView);
        this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.LOAD);
        if (exception != null) {
            this.handleException((RuntimeException)((Object)new ConfigurationServiceException("Failed Loading " + configDesc.getDescriptionName(), (Throwable)exception)), ConfigurationListener.ConfigurationOperation.LOAD);
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, level=0)
    public ConfigurationInfo getConfigurationInfo() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationInfo configurationInfo = this.currentConfigInfo;
            return configurationInfo;
        }
    }

    @Command(description="return the initial configuration for the provided categories", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public ConfigurationDescription getInitialConfigurationDescription(String ... categories) {
        return this.cloneConfigurationDescriptionForCategories(this.defaultInitialDescription, categories);
    }

    @Command(description="return the requested configuration for the provided categories", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public ConfigurationDescription getRequestedConfigurationDescription(String ... categories) {
        return this.cloneConfigurationDescriptionForCategories(this.requestedDescription, categories);
    }

    @Command(description="return the current configuration for the provided categories", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public ConfigurationDescription getCurrentConfigurationDescription(String ... categories) {
        return this.cloneConfigurationDescriptionForCategories(this.currentConfigInfo.getConfigurationDescriptionObject(), categories);
    }

    private ConfigurationDescription cloneConfigurationDescriptionForCategories(ConfigurationDescription cdToClone, String ... categories) {
        HashSet<String> requestedCategories = new HashSet<String>();
        if (categories == null | categories.length == 0) {
            requestedCategories = this.getCategories();
        } else {
            requestedCategories.addAll(Arrays.asList(categories));
            this.checkCategories(requestedCategories);
        }
        return cdToClone.cloneForCategories(requestedCategories);
    }

    public void setReadOnlyParameter(String componentName, String parameterName, Object value) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            if (!this.isParameterReadOnly(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a read-only configuration parameter");
            }
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value, true);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    @Command(description="publish a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, level=0)
    public void publishConfigurationInfo() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationInfo ci = this.getConfigurationInfo();
            this.agent.sendStatusMessage((StatusMessage)new StatusConfigurationInfo(ci));
            this.publishChecksumInfo();
        }
    }

    private void publishChecksumInfo() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            if (this.publishChecksum) {
                ConfigurationInfo ci = this.getConfigurationInfo();
                KeyValueDataList dataList = new KeyValueDataList("", this.configurationDataAttributes);
                for (String category : this.categories) {
                    Long checkSum = ci.getCategoryDataChecksum(category);
                    dataList.addData("config/data/" + category + "/checksum", (Serializable)checkSum);
                }
                this.agent.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
            }
        }
    }

    @Command(description="Submits a single change to be processed immediately", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void change(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName, Object value) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            if (!this.isParameterConfigurable(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a configuration parameter");
            }
            if (this.isParameterReadOnly(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is a read-only configuration parameter");
            }
            this.checkForSubmittedChanges();
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    public List<String> getAllConfigurableComponents() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ArrayList<String> arrayList = new ArrayList<String>(this.configurationHandler.getConfigurableComponents());
            return arrayList;
        }
    }

    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChange(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName, Object value) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            this.configurationHandler.submitChange(componentName, parameterName, value);
        }
    }

    @Command(description="Submits changes of parameters to be validated later", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChanges(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, Map<String, Object> changes) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            for (Map.Entry<String, Object> entry : changes.entrySet()) {
                this.configurationHandler.submitChange(componentName, entry.getKey(), entry.getValue());
            }
        }
    }

    @Command(name="applySubmittedChanges", description="processes the bulk change", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void commitBulkChange() {
        this.commitBulkChangeForComponent(null);
    }

    public void commitBulkChangeForComponent(String component) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.checkValidStates(true);
            try {
                ConfigurationView view = this.configurationHandler.commitBulkChange(null, component);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
                conf_sub_log.log(Level.FINEST, this.currentConfigInfo.getLatestChanges().size() + " successfully set parameters");
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    @Command(description="Drops the submitted changes for all components", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropAllSubmittedChanges() {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.configurationHandler.dropAllSubmittedChanges();
        }
    }

    @Command(description="Drops the submitted changes for the given component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents", description="the component name") String name) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            this.configurationHandler.dropSubmittedChangesForComponent(name);
        }
    }

    @Command(description="Returns the current submitted changes for the given component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, String> getSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents", description="the component name") String name) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getSubmittedChangesForComponent(name);
            return map;
        }
    }

    @Command(description="Returns the current submitted changes for each component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getAllSubmittedChanges();
            return map;
        }
    }

    @Command(description="returns the categories of this subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    List<String> getCategoriesList() {
        return new ArrayList<String>(this.getCategories());
    }

    @Command(description="returns the current values for a given component that belong to the specified categories", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public Map<String, String> getConfigurationParameterValuesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String ... categories) {
        this.verifyInputComponentName(componentName);
        this.verifyInputCategories(categories);
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            HashSet<String> categorySet = new HashSet<String>();
            if (categories != null) {
                categorySet.addAll(Arrays.asList(categories));
            }
            Map map = this.configurationHandler.getCurrentValuesForComponent(componentName, categorySet);
            return map;
        }
    }

    private boolean isParameterConfigurable(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            boolean bl = this.configurationHandler.isParameterConfigurable(componentName, parameterName);
            return bl;
        }
    }

    public boolean isParameterReadOnly(String componentName, String parameterName) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            boolean bl = this.configurationHandler.isParameterReadOnly(componentName, parameterName);
            return bl;
        }
    }

    public ConfigurationLock acquireConfigurationLock() {
        return new ConfigurationLock();
    }

    public ConfigurationLock tryAcquireConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationLock(time, unit);
    }

    public ConfigurationWriteLock acquireConfigurationWriteLock() {
        return new ConfigurationWriteLock();
    }

    public ConfigurationWriteLock tryAcquireConfigurationWriteLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationWriteLock(time, unit);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Provided name cannot be null.");
        }
        ComponentConfigurationEnvironment environment = this.keyEnvironmentMap.get(name);
        if (environment == null) {
            throw new IllegalArgumentException("No Component with name \"" + name + "\" containing configuration parameters.");
        }
        return environment;
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.add(listener);
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.remove(listener);
    }

    private void notifyConfigurationListeners(ConfigurationInfo newConfigurationInfo, ConfigurationInfo oldConfigurationInfo, ConfigurationListener.ConfigurationOperation co) {
        for (ConfigurationListener l : this.configurationListeners) {
            try {
                l.configurationChanged(newConfigurationInfo, oldConfigurationInfo, co);
            }
            catch (Exception e) {
                conf_sub_log.log(Level.WARNING, "ConfigurationListener exception", e);
            }
        }
    }

    private void notifyConfigurationListeners(ConfigurationInfo configurationInfo, ConfigurationListener.ConfigurationOperation co, Exception exception) {
        for (ConfigurationListener l : this.configurationListeners) {
            try {
                l.failedConfigurationOperation(configurationInfo, co, exception);
            }
            catch (Exception e) {
                conf_sub_log.log(Level.WARNING, "ConfigurationListener exception", e);
            }
        }
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co) {
        this.updateStateAndSendStatusConfigurationInfo(ci, co, true);
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co, boolean notifyListeners) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo previousConfigurationInfo = this.currentConfigInfo;
            this.currentConfigInfo = ci;
            this.currentView = this.extractConfigurationViewFromConfigurationInfo(this.currentConfigInfo);
            this.stateService.updateInternalState(new AgentState[]{this.currentConfigInfo.getConfigurationState()});
            if (this.messagingService.isConnectedToTheBuses()) {
                this.publishConfigurationInfo();
            }
            if (notifyListeners) {
                this.notifyConfigurationListeners(this.currentConfigInfo, previousConfigurationInfo, co);
            }
            conf_sub_log.log(this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.CONSOLE) > 0 ? Level.INFO : Level.FINE, "Updated configuration description: \n{0}\n", this.getCurrentConfigurationDescription(new String[0]));
        }
    }

    public ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo.Builder builder = this.buildConfigurationInfoInternal(newView, true);
            return builder;
        }
    }

    public ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView, boolean mustBeComplete) {
        try (ConfigurationWriteLock wlock = this.acquireConfigurationWriteLock();){
            ConfigurationInfo.Builder builder = this.buildConfigurationInfoInternal(newView, mustBeComplete);
            return builder;
        }
    }

    private ConfigurationInfo.Builder buildConfigurationInfoInternal(ConfigurationView newView, boolean mustBeComplete) {
        ConfigurationDescription configDesc = newView.getConfigurationDescription();
        ConfigurationDescription fullConfigDesc = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo);
        if (configDesc != null) {
            for (Object category : configDesc.getCategoriesSet()) {
                fullConfigDesc.addCategoryTag(configDesc.getCategoryTag((String)category));
            }
        }
        if (configDesc == null) {
            configDesc = new ConfigurationDescription(this.categories);
        }
        ConfigurationDescription cd = new ConfigurationDescription(this.categories);
        for (String cat : this.currentConfigInfo.getCategorySet()) {
            if (fullConfigDesc.containsCategory(cat)) {
                CategoryDescription categoryTag = fullConfigDesc.getCategoryTag(cat);
                cd.addCategoryTag(categoryTag);
                continue;
            }
            throw new RuntimeException("Should not have got here!");
        }
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(this.descriptionName);
        ConfigurationState nextState = ConfigurationState.CONFIGURED;
        for (Map.Entry entry : ConfigurationInfo.getParameterInfoGroupByCategory((List)this.currentConfigInfo.getAllParameterInfo()).entrySet()) {
            String category = (String)entry.getKey();
            boolean categoryCommitted = configDesc.containsCategory(category);
            boolean dirtyCat = false;
            for (ConfigurationParameterInfo cpi : (List)entry.getValue()) {
                boolean dirtyParm;
                ParameterPath path = ParameterPath.valueOf((String)cpi.getPathName());
                String currentValue = null;
                try {
                    currentValue = newView.getPathValue(path);
                }
                catch (Exception e) {
                    if (!mustBeComplete) continue;
                    throw e;
                }
                if (currentValue == null) continue;
                String configuredValue = categoryCommitted ? currentValue : cpi.getConfiguredValue();
                ciBuilder.addParameter(ParameterPath.valueOf((String)cpi.getPathName()), cpi.getActualType(), cpi.getCategoryName(), cpi.getDescription(), cpi.isFinal(), cpi.isReadOnly(), cpi.isBuild());
                boolean bl = dirtyParm = !cpi.isReadOnly() && !currentValue.equals(configuredValue);
                if (!currentValue.equals(this.currentConfigInfo.getCurrentValueForParameter(path.toString())) || dirtyParm != cpi.isDirty()) {
                    ciBuilder.addRecentChange(path.toString());
                }
                ciBuilder.updateParameter(ParameterPath.valueOf((String)cpi.getPathName()), configuredValue, currentValue, dirtyParm);
                if (!dirtyParm) continue;
                dirtyCat = true;
                nextState = ConfigurationState.DIRTY;
            }
            CategoryDescription categoryTag = cd.getCategoryTag(category);
            categoryTag.setHasChanges(dirtyCat);
        }
        if (!this.canGoToConfigured) {
            nextState = ConfigurationState.UNCONFIGURED;
        }
        return ciBuilder.setConfigurationState(nextState).setCCSTimeStamp(CCSTimeStamp.currentTime()).updateConfigurationDescription(cd.getFullDescriptionName(), cd.getDescriptionName());
    }

    ConfigurationView extractConfigurationViewFromCurrentConfigurationInfo() {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = this.extractConfigurationViewFromConfigurationInfo(this.currentConfigInfo);
            return configurationView;
        }
    }

    ConfigurationView extractConfigurationViewFromConfigurationInfo(ConfigurationInfo ci) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationView configurationView = this.extractConfigurationViewFromConfigurationInfo(ci, Collections.emptySet());
            return configurationView;
        }
    }

    ConfigurationView extractConfigurationViewFromConfigurationInfo(ConfigurationInfo ci, Set<String> categories) {
        ConfigurationView cv = new ConfigurationView();
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            List list = ci.getAllParameterInfo();
            for (ConfigurationParameterInfo cpi : list) {
                String parameterCategory;
                if (!categories.isEmpty() && !categories.contains(parameterCategory = this.configurationHandler.getParameterSet(cpi.getComponentName()).getConfigurationParameterHandler(cpi.getParameterName()).getCategory())) continue;
                cv.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getCurrentValue());
            }
        }
        ConfigurationDescription cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci);
        cv.setConfigurationDescription(cd);
        return cv;
    }

    private void checkCategories(Set<String> categories) {
        for (String cat : categories) {
            if (this.categories.contains(cat)) continue;
            throw new IllegalArgumentException("The provided category \"" + cat + "\" does not exist. Valid categories are: " + this.categories);
        }
    }

    private void checkValidStates(boolean failIfNotEM) {
        if (this.configurationHandler == null) {
            throw new IllegalStateException("the configuration service is not initialized yet");
        }
        if (failIfNotEM && !this.agent.isInEngineeringMode()) {
            throw new IllegalStateException("Fine grained configuration actions are accepted only in engineering mode");
        }
    }

    private void checkForSubmittedChanges() {
        if (this.configurationHandler.hasSubmittedChanges()) {
            throw new RuntimeException("A load/save/change operation cannot be performed while there are outstanding uncommitted changes.\nTo view the submitted changes issue the command \"getAllSubmittedChanges\".\nTo allow load/save/change operation you can either commit the submitted changes with \"applySubmittedChanges\" or you can drop them by issuing command \"dropAllSubmittedChanges\"");
        }
    }

    private void handleException(RuntimeException ex, ConfigurationListener.ConfigurationOperation co) {
        if (!co.equals((Object)ConfigurationListener.ConfigurationOperation.LOAD)) {
            ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
            this.updateStateAndSendStatusConfigurationInfo(this.buildConfigurationInfo(view).build(), co);
        }
        if (ex instanceof ConfigurationServiceException) {
            this.alertService.raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
        } else if (ex instanceof BulkSettingException) {
            this.alertService.raiseAlert(CS_ALERT_2, AlertState.ALARM, ex.getMessage());
        }
        throw ex;
    }

    public List<ConfigurationParameterHandler> getCategoryParameters(String category) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ArrayList result = new ArrayList(this.configurationHandler.getCategoryHandler(category).getParameters());
            List<ConfigurationParameterHandler> list = Collections.unmodifiableList(result);
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationParameterHandler getParameterByPath(ParameterPath path) {
        try (ConfigurationLock rlock = this.acquireConfigurationLock();){
            ConfigurationParameterHandler configurationParameterHandler = this.configurationHandler.getParameterSet(path.getComponentName()).getConfigurationParameterHandler(path.getParameterName());
            return configurationParameterHandler;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem fetching parameter for path " + path.toString(), e);
        }
    }

    public boolean saveInitialConfiguration() {
        return this.saveInitialConfiguration;
    }

    public ConfigurationView getInitialView() {
        ConfigurationView result = new ConfigurationView();
        if (this.initialView != null) {
            result.putAll(this.initialView);
        }
        return result;
    }

    public class ConfigurationWriteLock
    implements AutoCloseable {
        public final Lock writeLock;

        private ConfigurationWriteLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            this.writeLock = ConfigurationService.this.configLock.writeLock();
            if (!this.writeLock.tryLock(time, unit)) {
                throw new TimeoutException("Could not acquire a writer lock within the given time.");
            }
        }

        private ConfigurationWriteLock() {
            this.writeLock = ConfigurationService.this.configLock.writeLock();
            this.writeLock.lock();
        }

        @Override
        public void close() {
            this.writeLock.unlock();
        }
    }

    public class ConfigurationLock
    implements AutoCloseable {
        public final Lock readLock;

        private ConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            this.readLock = ConfigurationService.this.configLock.readLock();
            if (!this.readLock.tryLock(time, unit)) {
                throw new TimeoutException("Could not acquire a reader lock within the given time.");
            }
        }

        private ConfigurationLock() {
            this.readLock = ConfigurationService.this.configLock.readLock();
            this.readLock.lock();
        }

        @Override
        public void close() {
            this.readLock.unlock();
        }
    }
}

