/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.EOFException;
import java.io.IOException;
import java.nio.IntBuffer;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;

public class BufferedReadableIntChannel
implements ReadableIntChannel {
    private final IntBuffer internalBuffer;
    private final ReadableIntChannel input;

    public BufferedReadableIntChannel(ReadableIntChannel input, int bufSize) {
        this.internalBuffer = IntBuffer.allocate(bufSize);
        this.input = input;
    }

    @Override
    public int read(IntBuffer buffer) throws IOException {
        if (this.internalBuffer.hasRemaining()) {
            int remaining = this.internalBuffer.remaining();
            this.internalBuffer.put(buffer);
            return remaining - this.internalBuffer.remaining();
        }
        return this.input.read(buffer);
    }

    @Override
    public int read() throws IOException {
        if (!this.internalBuffer.hasRemaining()) {
            this.internalBuffer.clear();
            this.input.read(this.internalBuffer);
            this.internalBuffer.flip();
        }
        if (this.internalBuffer.hasRemaining()) {
            return this.internalBuffer.get();
        }
        throw new EOFException();
    }

    @Override
    public boolean isOpen() {
        return this.input.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

