package org.lsst.ccs.subsystem.focalplane;

import java.io.File;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;

/**
 * Sequencer and Fits File configuration for the focal plane subsystem
 */
@SuppressWarnings("FieldMayBeFinal")
public class FocalPlaneConfig implements ConfigurationBulkChangeHandler {
    
    @ConfigurationParameter(category = "FitsHandling")
    private String FITSRootDirectory = System.getProperty("java.io.tmpdir");
    
    @ConfigurationParameter(category = "FitsHandling")
    private String FITSDirectoryPattern = "${imageDate}/${imageName}";

    @ConfigurationParameter(category = "FitsHandling")
    private String FITSFilePattern = "${imageName}_${raftName}_S${sensorLoc}.fits";

    @ConfigurationParameter(category = "FitsHandling")
    private boolean FITSAutoSave = true;
    
    public String getFITSRootDirectory() {
        return FITSRootDirectory;
    }

    public String getFITSDirectoryPattern() {
        return FITSDirectoryPattern;
    }

    public String getFITSFilePattern() {
        return FITSFilePattern;
    }

    public boolean isFITSAutoSave() {
        return FITSAutoSave;
    }

    @Override
    public void validateBulkChange(Map<String, Object> parametersView) {
        String dir = parametersView.get("FITSRootDirectory").toString();
        File dirFile  = new File(dir);
        dirFile.mkdirs();
        if (!dirFile.isDirectory()) throw new IllegalArgumentException("FITSRootDirectory: Not a directory");
        if (!dirFile.canWrite()) throw new IllegalArgumentException("FITSRootDirectory: Not writable");
    }
}
