/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;

public class DemultiplexingIntChannel
implements WritableIntChannel {
    private final WritableIntChannel[] destinations;
    private final int size;
    private int next;
    private boolean isClosed;

    public DemultiplexingIntChannel(WritableIntChannel ... destinations) {
        this.destinations = destinations;
        this.size = destinations.length;
        this.next = 0;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public void close() throws IOException {
        for (WritableIntChannel channel : this.destinations) {
            channel.close();
        }
        this.isClosed = true;
    }

    @Override
    public void write(int i) throws IOException {
        this.destinations[this.next++].write(i);
        if (this.next >= this.size) {
            this.next = 0;
        }
    }
}

