/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

public class BiasControl
extends Control
implements ConfigurationBulkChangeHandler {
    public static final String GD_P = "gdP";
    public static final String OD_P = "odP";
    public static final String OG_P = "ogP";
    public static final String RD_P = "rdP";
    public static final String CS_GATE_P = "csGateP";
    public static final String GD = "gd";
    public static final String OD = "od";
    public static final String OG = "og";
    public static final String OG_SH = "ogSh";
    public static final String RD = "rd";
    public static final String CS_GATE = "csGate";
    private static final int GD_CH = 1;
    private static final int OD_CH = 2;
    private static final int OG_CH = 4;
    private static final int OG_SH_CH = 8;
    private static final int RD_CH = 16;
    private static final int CSGATE_CH = 32;
    private static final String[] checkList = new String[]{"gd", "od", "og", "rd"};
    private static final int[] OD_ADCS = new int[]{7, 11, 15};
    private static final int[] GD_ADCS = new int[]{6, 10, 14};
    private static final int[] RD_ADCS = new int[]{9, 13, 17};
    private static final int[] OG_ADCS = new int[]{8, 12, 16};
    private static final double DAC_TOLERANCE = 0.33;
    private static final int DEFAULT_LOAD_WAIT = 160;
    private static final int DEFAULT_CLEAR_WAIT = 50;
    private static final double TEST_VOLTS = 0.5;
    private static final double ZERO_ERROR = 0.2;
    private static final double VALUE_ERROR = 0.2;
    private static final double OD_SHORTS_LIMIT = 0.005;
    private static final double CLKH_SHORTS_LIMIT = 0.005;
    private static final double CLKL_SHORTS_LIMIT = 0.005;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @ConfigurationParameter(category="Rafts", description="Guard diode", units="volts")
    private double gdP;
    @ConfigurationParameter(category="Rafts", description="Output drain", units="volts")
    private double odP;
    @ConfigurationParameter(category="Rafts", description="Output gate", units="volts")
    private double ogP;
    @ConfigurationParameter(category="Rafts", description="Reset drain", units="volts")
    private double rdP;
    @ConfigurationParameter(category="Rafts", description="Current source", units="mA")
    private double csGateP;
    @ConfigurationParameter(category="RaftsLimits", description="Guard diode min", units="volts")
    private double gdMin;
    @ConfigurationParameter(category="RaftsLimits", description="Guard diode max", units="volts")
    private double gdMax;
    @ConfigurationParameter(category="RaftsLimits", description="Output drain min", units="volts")
    private double odMin;
    @ConfigurationParameter(category="RaftsLimits", description="Output drain max", units="volts")
    private double odMax;
    @ConfigurationParameter(category="RaftsLimits", description="Output gate min", units="volts")
    private double ogMin;
    @ConfigurationParameter(category="RaftsLimits", description="Output gate max", units="volts")
    private double ogMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset drain min", units="volts")
    private double rdMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset drain max", units="volts")
    private double rdMax;
    @ConfigurationParameter(category="Rafts", description="Guard diode", units="DAC counts")
    private int gd;
    @ConfigurationParameter(category="Rafts", description="Output drain", units="DAC counts")
    private int od;
    @ConfigurationParameter(category="Rafts", description="Output gate", units="DAC counts")
    private int og;
    @ConfigurationParameter(category="Rafts", description="Output gate shifted", units="DAC counts")
    private int ogSh;
    @ConfigurationParameter(category="Rafts", description="Reset drain", units="DAC counts")
    private int rd;
    @ConfigurationParameter(category="Rafts", description="Current source", units="DAC counts")
    private int csGate;
    @ConfigurationParameter(category="RaftsPower", description="Guard diode tolerance", units="volts")
    private double gdTol;
    @ConfigurationParameter(category="RaftsPower", description="Guard diode offset", units="volts")
    private double gdOff;
    @ConfigurationParameter(category="RaftsPower", description="Output drain tolerance", units="volts")
    private double odTol;
    @ConfigurationParameter(category="RaftsPower", description="Output drain offset", units="volts")
    private double odOff;
    @ConfigurationParameter(category="RaftsPower", description="Output gate tolerance", units="volts")
    private double ogTol;
    @ConfigurationParameter(category="RaftsPower", description="Output gate offset", units="volts")
    private double ogOff;
    @ConfigurationParameter(category="RaftsPower", description="Reset drain tolerance", units="volts")
    private double rdTol;
    @ConfigurationParameter(category="RaftsPower", description="Reset drain offset", units="volts")
    private double rdOff;
    @ConfigurationParameter(category="RaftsPower", description="Max ODI value", units="Amps")
    private double odIMax;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for GD", units="Volts")
    private double gdTestVolts;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for GD at 0V", units="Volts")
    private double gdZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for GD at TestVolts", units="Volts")
    private double gdValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for OG", units="Volts")
    private double ogTestVolts;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for OG at 0V", units="Volts")
    private double ogZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for OG at TestVolts", units="Volts")
    private double ogValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for RD", units="Volts")
    private double rdTestVolts;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for RD at 0V", units="Volts")
    private double rdZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for RD at TestVolts", units="Volts")
    private double rdValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for OD at 0V", units="Volts")
    private double odZeroErr;
    private boolean raw = false;
    private static final Logger LOG = Logger.getLogger(BiasControl.class.getName());
    private REBDevice rebDevc;
    private boolean cfgValid;
    private int hwVersion;
    private BoardDacs dac;
    private int changed = -1;
    private final Map<String, Double> lowLimitMap = new HashMap<String, Double>();
    private final Map<String, Double> highLimitMap = new HashMap<String, Double>();
    private double gdConv;
    private double odConv;
    private double rdConv;
    private double ogConv;
    private double ogShiftConv;
    private double csConv;
    private double csOffset;
    private int adcType;

    public BiasControl() {
        for (String pName : checkList) {
            this.lowLimitMap.put(pName, 0.0);
            this.highLimitMap.put(pName, 0.0);
        }
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.rebDevc = (REBDevice)devc;
        this.dac = this.rebDevc.getBoardDacs();
    }

    public boolean checkConfig() {
        this.hwVersion = BiasControl.getHwVersion(this.dac);
        if (this.hwVersion == -1) {
            LOG.log(Level.SEVERE, "{0} configuration incompatible with the firmware", this.getName());
            return false;
        }
        try {
            if (this.hwChan < 0 || this.hwChan >= this.dac.getNumStrips()) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)this.getName(), (String)"HW channel", (Object)this.hwChan);
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting number of strips for {0}", this.getName());
            return false;
        }
        catch (Exception e) {
            return false;
        }
        if (!this.raw) {
            switch (this.hwVersion) {
                case 1: {
                    this.gdConv = this.odConv = 136.7278797996661;
                    this.rdConv = this.odConv;
                    break;
                }
                case 2: {
                    this.odConv = 112.769123783032;
                    this.gdConv = 113.75;
                    this.rdConv = 163.14741035856574;
                    break;
                }
                default: {
                    this.gdConv = this.odConv = 113.75;
                    this.rdConv = 163.14741035856574;
                }
            }
            double ogGain = 1.0;
            double fudge = this.hwVersion == 3 ? 1.0 : 1.1;
            this.ogShiftConv = fudge * 819.0 / ogGain;
            this.ogConv = fudge * 819.0 / (1.0 + ogGain);
            this.csConv = 1638.0;
            this.csOffset = -0.95;
        } else {
            this.cfgValid = true;
        }
        this.adcType = this.hwVersion == 2 ? 4 : 6;
        return true;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public static int getHwVersion(BoardDacs dac) {
        int version = dac.getVersion();
        switch (version) {
            case 2: 
            case 4: 
            case 5: {
                version = 1;
                break;
            }
            case 3: 
            case 6: {
                version = 2;
                break;
            }
            case 7: 
            case 8: {
                version = 3;
                break;
            }
            default: {
                version = -1;
            }
        }
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    public void validateBulkChange(Map<String, Object> params) throws IllegalArgumentException {
        String errMsg = null;
        if (!this.raw) {
            for (String pName : checkList) {
                Double max;
                double value = (Double)params.get(pName + "P");
                if (value > (max = (Double)params.get(pName + "Max"))) {
                    errMsg = String.format("%s: %sP (%5.5g) is above high limit (%5.5g)", this.getName(), pName, value, max);
                    break;
                }
                Double min = (Double)params.get(pName + "Min");
                if (!(value < min)) continue;
                errMsg = String.format("%s: %sP (%5.5g) is below low limit (%5.5g)", this.getName(), pName, value, min);
                break;
            }
        }
        if (errMsg != null) {
            LOG.log(Level.SEVERE, "Configuration failure: {0}", errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        this.cfgValid = true;
    }

    @ConfigurationParameterChanger
    public void setGdP(double value) {
        this.gdP = value;
        this.changed |= 1;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Guard Diode voltage")
    public double getGdP() {
        return this.gdP;
    }

    @ConfigurationParameterChanger
    public void setGdMax(double value) {
        this.gdMax = value;
        this.highLimitMap.put(GD, value);
    }

    @ConfigurationParameterChanger
    public void setGdMin(double value) {
        this.gdMin = value;
        this.lowLimitMap.put(GD, value);
    }

    @ConfigurationParameterChanger
    public void setGd(int value) {
        this.gd = value;
        this.changed |= 1;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Guard Diode DAC value")
    public int getGd() {
        return this.gd;
    }

    @ConfigurationParameterChanger
    public void setOdP(double value) {
        this.odP = value;
        this.changed |= 2;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the readout mode Output Drain voltage")
    public double getOdP() {
        return this.odP;
    }

    @ConfigurationParameterChanger
    public void setOdMax(double value) {
        this.odMax = value;
        this.highLimitMap.put(OD, value);
    }

    @ConfigurationParameterChanger
    public void setOdMin(double value) {
        this.odMin = value;
        this.lowLimitMap.put(OD, value);
    }

    @ConfigurationParameterChanger
    public void setOd(int value) {
        this.od = value;
        this.changed |= 2;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the readout mode Output Drain DAC value")
    public int getOd() {
        return this.od;
    }

    @ConfigurationParameterChanger
    public void setOgP(double value) {
        this.ogP = value;
        this.changed |= 4;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Output Gate voltage")
    public double getOgP() {
        return this.ogP;
    }

    @ConfigurationParameterChanger
    public void setOgMax(double value) {
        this.ogMax = value;
        this.highLimitMap.put(OG, value);
    }

    @ConfigurationParameterChanger
    public void setOgMin(double value) {
        this.ogMin = value;
        this.lowLimitMap.put(OG, value);
    }

    @ConfigurationParameterChanger
    public void setOg(int value) {
        this.og = value;
        this.changed |= 4;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Output Gate DAC value")
    public int getOg() {
        return this.og;
    }

    @ConfigurationParameterChanger
    public void setOgSh(int value) {
        this.ogSh = value;
        this.changed |= 8;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Output Gate shift DAC value")
    public int getOgSh() {
        return this.ogSh;
    }

    @ConfigurationParameterChanger
    public void setRdP(double value) {
        this.rdP = value;
        this.changed |= 0x10;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Reset Drain voltage")
    public double getRdP() {
        return this.rdP;
    }

    @ConfigurationParameterChanger
    public void setRdMax(double value) {
        this.rdMax = value;
        this.highLimitMap.put(RD, value);
    }

    @ConfigurationParameterChanger
    public void setRdMin(double value) {
        this.rdMin = value;
        this.lowLimitMap.put(RD, value);
    }

    @ConfigurationParameterChanger
    public void setRd(int value) {
        this.rd = value;
        this.changed |= 0x10;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Reset Drain DAC value")
    public int getRd() {
        return this.rd;
    }

    @ConfigurationParameterChanger
    public void setCsGateP(double value) {
        this.csGateP = value;
        this.changed |= 0x20;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Current Source gate")
    public double getCsGateP() {
        return this.csGateP;
    }

    @ConfigurationParameterChanger
    public void setCsGate(int value) {
        this.csGate = value;
        this.changed |= 0x20;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Current Source gate")
    public int getCsGate() {
        return this.csGate;
    }

    void setConfig(BiasDACS bias) throws RaftException {
        String name = this.getName();
        if (!this.raw) {
            double[] values = bias.getPValues();
            this.sce.submitChange(name, GD_P, (Object)values[0]);
            this.sce.submitChange(name, OD_P, (Object)values[1]);
            this.sce.submitChange(name, OG_P, (Object)values[2]);
            this.sce.submitChange(name, RD_P, (Object)values[5]);
            this.sce.submitChange(name, CS_GATE_P, (Object)values[4]);
        } else {
            int[] values = bias.getValues();
            this.sce.submitChange(name, GD, (Object)values[0]);
            this.sce.submitChange(name, OD, (Object)values[1]);
            this.sce.submitChange(name, OG, (Object)values[2]);
            this.sce.submitChange(name, OG_SH, (Object)values[3]);
            this.sce.submitChange(name, RD, (Object)values[5]);
            this.sce.submitChange(name, CS_GATE, (Object)values[4]);
        }
        try {
            this.sce.commitBulkChange();
        }
        catch (BulkValidationException e) {
            this.sce.dropSubmittedChangesForComponent(name);
            throw new RaftException("Bulk configuration validation failed");
        }
    }

    BiasDACS getConfig() {
        BiasDACS bias = new BiasDACS();
        if (!this.raw) {
            double[] values = bias.getPValues();
            values[0] = this.gdP;
            values[1] = this.odP;
            values[2] = this.ogP;
            values[5] = this.rdP;
            values[4] = this.csGateP;
        } else {
            int[] values = bias.getValues();
            values[0] = this.gd;
            values[1] = this.od;
            values[2] = this.og;
            values[3] = this.ogSh;
            values[5] = this.rd;
            values[4] = this.csGate;
        }
        return bias;
    }

    int load(boolean check, List<REBDevice.AdcData> adcDataList) throws RaftException {
        return this.load(160, check, false, adcDataList);
    }

    int load(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.load(wait, check, false, dataList);
    }

    int load(int wait, boolean check, boolean odStep, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        this.rebDevc.readAllAdcs(dataList);
        if (this.isItlCcd()) {
            this.loadOg(wait, check, dataList);
            this.loadGd(wait, check, dataList);
            this.loadRd(wait, check, dataList);
            this.loadOd(wait, check, dataList, odStep);
        } else {
            this.loadRd(wait, check, dataList);
            this.loadOd(wait, check, dataList, odStep);
            this.loadGd(wait, check, dataList);
            this.loadOg(wait, check, dataList);
        }
        this.loadCsGate(0);
        this.changed = 0;
        return 6;
    }

    int loadChanged(boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.loadChanged(160, check, dataList);
    }

    int loadChanged(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.loadChanged(160, check, false, dataList);
    }

    int loadChanged(int wait, boolean check, boolean odStep, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        int count = 0;
        this.rebDevc.readAllAdcs(dataList);
        if (this.isItlCcd()) {
            if ((this.changed & 4) != 0) {
                this.loadOg(wait, check, dataList);
                count += 2;
            }
            if ((this.changed & 1) != 0) {
                this.loadGd(wait, check, dataList);
                ++count;
            }
            if ((this.changed & 0x10) != 0) {
                this.loadRd(wait, check, dataList);
                ++count;
            }
            if ((this.changed & 2) != 0) {
                this.loadOd(wait, check, dataList, odStep);
                ++count;
            }
        } else {
            if ((this.changed & 0x10) != 0) {
                this.loadRd(wait, check, dataList);
                ++count;
            }
            if ((this.changed & 2) != 0) {
                this.loadOd(wait, check, dataList, odStep);
                ++count;
            }
            if ((this.changed & 1) != 0) {
                this.loadGd(wait, check, dataList);
                ++count;
            }
            if ((this.changed & 4) != 0) {
                this.loadOg(wait, check, dataList);
                count += 2;
            }
        }
        if ((this.changed & 0x20) != 0) {
            this.loadCsGate(0);
            ++count;
        }
        this.changed = 0;
        return count;
    }

    void clear(List<REBDevice.AdcData> dataList) throws RaftException {
        this.clear(50, dataList);
    }

    void clear(int wait, List<REBDevice.AdcData> dataList) throws RaftException {
        this.clearCsGate(0);
        if (this.isItlCcd()) {
            this.clearOd(wait);
            this.clearRd(wait);
            this.clearGd(wait);
            this.clearOg(wait);
        } else {
            this.clearOg(wait);
            this.clearGd(wait);
            this.clearOd(wait);
            this.clearRd(wait);
        }
        this.changed = -1;
        this.rebDevc.readAllAdcs(dataList);
    }

    public boolean testShorts(List<REBDevice.AdcData> dataList, StringBuilder fcause) throws RaftException {
        boolean failed = this.testShorts(14, this.rdConv, RD_ADCS[this.hwChan], this.rdTestVolts, this.rdValueErr, this.rdZeroErr, dataList, fcause);
        failed |= this.testShorts(13, this.gdConv, GD_ADCS[this.hwChan], this.gdTestVolts, this.gdValueErr, this.gdZeroErr, dataList, fcause);
        this.rebDevc.readAllAdcs(dataList);
        return failed |= this.testShorts(15, this.ogConv, OG_ADCS[this.hwChan], this.ogTestVolts, this.ogValueErr, this.ogZeroErr, dataList, fcause);
    }

    private boolean testShorts(int dac, double conv, int adc, double adcTestVolts, double adcValueErr, double adcZeroErr, List<REBDevice.AdcData> dataList, StringBuilder fcause) throws RaftException {
        boolean failed = false;
        double[] origPower = this.rebDevc.readPowerAdcs(dataList);
        double[] origAdcs = this.rebDevc.readSlowAdcs(dataList);
        this.setDac(dac, (int)(conv * adcTestVolts));
        this.loadDac(160);
        this.rebDevc.readAllAdcs(dataList);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        double[] curPower = this.rebDevc.readPowerAdcs(dataList);
        double[] currAdcs = this.rebDevc.readSlowAdcs(dataList);
        this.setDac(dac, 0);
        this.loadDac(50);
        this.rebDevc.readAllAdcs(dataList);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.rebDevc.readAllAdcs(dataList);
        for (int ad = 0; ad < currAdcs.length; ++ad) {
            double value = currAdcs[ad] - origAdcs[ad];
            if (ad == adc) {
                if (!(Math.abs(value - adcTestVolts) > adcValueErr)) continue;
                fcause.append(String.format("%s %s value (%.2f) is out of bounds %.2f (+/-%.2f)\n", this.rebDevc.getName(), REBDevice.getAdcName(ad), value, adcTestVolts, adcValueErr));
                failed = true;
                continue;
            }
            if (!(Math.abs(value) > adcZeroErr)) continue;
            fcause.append(String.format("%s %s value (%.2f) is non-zero while testing %s\n", this.rebDevc.getName(), REBDevice.getAdcName(ad), value, REBDevice.getAdcName(adc)));
            failed = true;
        }
        if (curPower[7] > origPower[7] + 0.005) {
            fcause.append(String.format("%s OD current increased excessively from %.1f mA to %.1f mA while testing %s\n", this.rebDevc.getName(), 1000.0 * origPower[7], 1000.0 * curPower[7], REBDevice.getAdcName(adc)));
            failed = true;
        }
        if (curPower[5] > origPower[5] + 0.005) {
            fcause.append(String.format("%s CLKH current increased excessively from %.1f mA to %.1f mA while testing %s\n", this.rebDevc.getName(), 1000.0 * origPower[5], 1000.0 * curPower[5], REBDevice.getAdcName(adc)));
            failed = true;
        }
        if (curPower[9] > origPower[9] + 0.005) {
            fcause.append(String.format("%s CLKL current increased excessively from %.1f mA to %.1f mA while testing %s\n", this.rebDevc.getName(), 1000.0 * origPower[9], 1000.0 * curPower[9], REBDevice.getAdcName(adc)));
            failed = true;
        }
        return failed;
    }

    private void loadGd(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.raw) {
            this.setDac(13, (int)(this.gdConv * this.gdP));
            this.loadDac(wait);
            RaftException ex = this.checkAdc(GD_ADCS[this.hwChan], dataList, check, this.gdP, this.gdOff, this.gdTol);
            if (ex != null) {
                this.clearGd(0);
                throw ex;
            }
        } else {
            this.setDac(13, this.gd);
            this.loadDac(wait);
        }
    }

    private void loadOd(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        this.loadOd(wait, check, dataList, false);
    }

    private void loadOd(int wait, boolean check, List<REBDevice.AdcData> dataList, boolean odStep) throws RaftException {
        if (!this.raw) {
            if (odStep) {
                double odStepP = 15.0;
                if (this.odP > odStepP) {
                    this.setDac(12, (int)(this.odConv * odStepP));
                    this.loadDac(wait);
                    RaftException ex = this.checkAdc(OD_ADCS[this.hwChan], dataList, check, odStepP, this.odOff, this.odTol);
                    if (ex != null) {
                        this.clearOd(0);
                        throw ex;
                    }
                } else {
                    throw new RaftException(String.format("odStepP (%.2f) > odP (%.2f), odP setting too low", odStepP, this.odP));
                }
            }
            this.setDac(12, (int)(this.odConv * this.odP));
            this.loadDac(wait);
            RaftException ex = this.checkAdc(OD_ADCS[this.hwChan], dataList, check, this.odP, this.odOff, this.odTol);
            if (ex != null) {
                this.clearOd(0);
                throw ex;
            }
        } else {
            this.setDac(12, this.od);
            this.loadDac(wait);
        }
    }

    private void loadOg(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.raw) {
            this.setDac(15, this.ogP > 0.0 ? (int)(this.ogConv * this.ogP) : 0);
            this.setDac(16, this.ogP < 0.0 ? (int)(-this.ogShiftConv * this.ogP) : 0);
            this.loadDac(wait);
            RaftException ex = this.checkAdc(OG_ADCS[this.hwChan], dataList, check, this.ogP, this.ogOff, this.ogTol);
            if (ex != null) {
                this.clearOg(0);
                throw ex;
            }
        } else {
            this.setDac(15, this.og);
            this.setDac(16, this.ogSh);
            this.loadDac(wait);
        }
    }

    private void loadRd(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.raw) {
            this.setDac(14, (int)(this.rdConv * this.rdP));
            this.loadDac(wait);
            RaftException ex = this.checkAdc(RD_ADCS[this.hwChan], dataList, check, this.rdP, this.rdOff, this.rdTol);
            if (ex != null) {
                this.clearRd(0);
                throw ex;
            }
        } else {
            this.setDac(14, this.rd);
            this.loadDac(wait);
        }
    }

    private void loadCsGate(int wait) throws RaftException {
        if (!this.raw) {
            this.setDac(17, (int)(this.csConv * (this.csGateP + this.csOffset)));
        } else {
            this.setDac(17, this.csGate);
        }
        this.loadDac(wait);
    }

    private RaftException checkAdc(int adc, List<REBDevice.AdcData> dataList, boolean check, double setPoint, double adcOff, double adcTol) throws RaftException {
        StringBuilder exString = new StringBuilder();
        RaftException re = null;
        boolean failed = false;
        if (!check && dataList == null) {
            return re;
        }
        double[] adcValues = this.rebDevc.readSlowAdcs(dataList);
        double[] curPower = this.rebDevc.readPowerAdcs(dataList);
        if (Math.abs(adcValues[adc] + adcOff - setPoint) > adcTol) {
            exString.append(String.format("%s %s out of range: setpt=%.2f, reading: %.2f, offset: %.2f, tol: %.2f\n", this.rebDevc.getName(), REBDevice.getAdcName(adc), setPoint, adcValues[adc], adcOff, adcTol));
            failed = true;
        }
        if (curPower[7] > this.odIMax) {
            exString.append(String.format("%s %s caused overcurrent on ODI: measured %.3f, limit: %.3f", this.rebDevc.getName(), REBDevice.getAdcName(adc), curPower[7], this.odIMax));
            failed = true;
        }
        if (failed) {
            if (check) {
                return new RaftException(exString.toString());
            }
            LOG.warning(exString.toString());
        }
        return re;
    }

    public int getBiasDacsPowerState(List<REBDevice.AdcData> dataList, StringBuilder fcause) throws RaftException {
        double[] origPower = this.rebDevc.readPowerAdcs(dataList);
        double[] slowAdcs = this.rebDevc.readSlowAdcs(dataList);
        int offCnt = 0;
        int onCnt = 0;
        double value = slowAdcs[RD_ADCS[this.hwChan]];
        if (Math.abs(value) < this.rdZeroErr) {
            ++offCnt;
            fcause.append(String.format("\n  %s %s voltage = %.2f in range for OFF", this.rebDevc.getName(), REBDevice.getAdcName(RD_ADCS[this.hwChan]), value));
        } else if (Math.abs(value + this.rdOff - this.rdP) < this.rdTol) {
            ++onCnt;
            fcause.append(String.format("\n  %s %s voltage = %.2f in range for ON\n", this.rebDevc.getName(), REBDevice.getAdcName(RD_ADCS[this.hwChan]), value));
        } else {
            fcause.append(String.format("\n  %s %s voltage = %.2f NOT in range for ON|OFF\n", this.rebDevc.getName(), REBDevice.getAdcName(RD_ADCS[this.hwChan]), value));
        }
        value = slowAdcs[OD_ADCS[this.hwChan]];
        if (Math.abs(value) < this.odZeroErr) {
            ++offCnt;
            fcause.append(String.format("\n  %s %s voltage = %.2f in range for OFF\n", this.rebDevc.getName(), REBDevice.getAdcName(OD_ADCS[this.hwChan]), value));
        } else if (Math.abs(value + this.odOff - this.odP) < this.odTol) {
            ++onCnt;
            fcause.append(String.format("\n  %s %s voltage = %.2f in range for ON\n", this.rebDevc.getName(), REBDevice.getAdcName(OD_ADCS[this.hwChan]), value));
        } else {
            fcause.append(String.format("\n  %s %s voltage = %.2f NOT in range for ON|OFF\n", this.rebDevc.getName(), REBDevice.getAdcName(OD_ADCS[this.hwChan]), value));
        }
        value = slowAdcs[GD_ADCS[this.hwChan]];
        if (Math.abs(value) < this.gdZeroErr) {
            ++offCnt;
            fcause.append(String.format("\n  %s %s voltage = %.2f in range for OFF\n", this.rebDevc.getName(), REBDevice.getAdcName(GD_ADCS[this.hwChan]), value));
        } else if (Math.abs(value + this.gdOff - this.gdP) < this.gdTol) {
            ++onCnt;
            fcause.append(String.format("\n  %s %s voltage = %.2f in range for ON\n", this.rebDevc.getName(), REBDevice.getAdcName(GD_ADCS[this.hwChan]), value));
        } else {
            fcause.append(String.format("\n  %s %s voltage = %.2f NOT in range for ON|OFF\n", this.rebDevc.getName(), REBDevice.getAdcName(GD_ADCS[this.hwChan]), value));
        }
        value = slowAdcs[OG_ADCS[this.hwChan]];
        if (Math.abs(value) < this.ogZeroErr) {
            ++offCnt;
            fcause.append(String.format("\n  %s %s voltage = %.2f in range for OFF\n", this.rebDevc.getName(), REBDevice.getAdcName(OG_ADCS[this.hwChan]), value));
        } else if (Math.abs(value + this.ogOff - this.ogP) < this.ogTol) {
            ++onCnt;
            fcause.append(String.format("\n  %s %s voltage = %.2f in range for ON\n", this.rebDevc.getName(), REBDevice.getAdcName(OG_ADCS[this.hwChan]), value));
        } else {
            fcause.append(String.format("\n  %s %s voltage = %.2f NOT in range for ON|OFF\n", this.rebDevc.getName(), REBDevice.getAdcName(OG_ADCS[this.hwChan]), value));
        }
        fcause.append(String.format("\n  %s: getBiasDacsPowerState() found %d(%d) ON(OFF) of biases", this.rebDevc.getName(), onCnt, offCnt));
        if (offCnt == 4) {
            return 0;
        }
        if (onCnt == 4) {
            return 1;
        }
        return -1;
    }

    private static boolean isValueOkay(double read, double set) {
        return Math.abs(read - set) <= 0.33;
    }

    private void clearGd(int wait) throws RaftException {
        this.setDac(13, 0);
        this.loadDac(wait);
    }

    private void clearOd(int wait) throws RaftException {
        this.setDac(12, 0);
        this.loadDac(wait);
    }

    private void clearOg(int wait) throws RaftException {
        this.setDac(15, 0);
        this.setDac(16, 0);
        this.loadDac(wait);
    }

    private void clearRd(int wait) throws RaftException {
        this.setDac(14, 0);
        this.loadDac(wait);
    }

    private void clearCsGate(int wait) throws RaftException {
        this.setDac(17, 0);
        this.loadDac(wait);
    }

    private void setDac(int chan, int value) throws RaftException {
        this.testOnline();
        try {
            this.dac.set(this.hwChan, chan, Math.max(0, Math.min(value, 4095)));
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    private void loadDac(int wait) throws RaftException {
        this.testOnline();
        try {
            this.dac.loadStrip(this.hwChan);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isItlCcd() {
        return this.rebDevc.getCcdType().getName().equals("itl");
    }
}

