/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20Analog;
import org.lsst.ccs.drivers.dataforth.Maq20AnalogIn;
import org.lsst.ccs.drivers.dataforth.Maq20AnalogOut;
import org.lsst.ccs.drivers.dataforth.Maq20Discrete;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteFreq;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePWM;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePulse;
import org.lsst.ccs.drivers.modbus.Modbus;

public class Maq20
extends Modbus {
    public static final int NUM_MODULES = 24;
    public static final int OPER_ANALOG = 0;
    public static final int OPER_ANALOUT = 1;
    public static final int OPER_DISCRETE = 2;
    static final short RANGE_ADDR = 100;
    static final short ZERO = 0;
    static final short ONE = 1;
    static final short TWO = 2;
    private static final short SLAVE_ADDR = 0;
    private static final short MODU_ADDR_INCR = 2000;
    private static final short DEV_NAME_ADDR = 0;
    private static final short DEV_NAME_LENG = 15;
    private static final short SER_NUM_ADDR = 20;
    private static final short SER_NUM_LENG = 10;
    private static final short DATE_CODE_ADDR = 31;
    private static final short DATE_CODE_LENG = 4;
    private static final short FW_REVN_ADDR = 36;
    private static final short FW_REVN_LENG = 4;
    private static final short IP_ADDRESS_ADDR = 50;
    private static final short IP_ADDRESS_LENG = 4;
    private static final short SUBNET_MASK_ADDR = 55;
    private static final short SAVE_PARMS_ADDR = 70;
    private static final short MODU_DETECT_ADDR = 98;
    private static final short RESET_ADDR = 99;
    private static final short MODU_STATUS_ADDR = 100;
    private static final short REGN_SN_ID_ADDR = 1000;
    private static final short AUTO_REGN_ADDR = 1020;
    private static final short SAVE_REGN_ADDR = 1021;
    private static final short DEL_REGN_ADDR = 1022;
    private static final short TEMPERATURE_ADDR = 1210;
    private static final short NUM_INP_CHANS_ADDR = 40;
    private static final short NUM_OUT_CHANS_ADDR = 41;
    private static final short RANGE_COUNT_ADDR = 1700;
    private static final short RANGE_DATA_ADDR = 1710;
    private static final short RANGE_DATA_INCR = 20;
    private static final short ENG_NFS_OFFS = 0;
    private static final short ENG_PFS_OFFS = 2;
    private static final short ENG_FS_PWR_OFFS = 4;
    private static final short CNT_NFS_OFFS = 8;
    private static final short CNT_PFS_OFFS = 10;
    private static final short NUM_CHANNELS = 16;
    private static final Map<String, ModuleType> typeMap = new HashMap<String, ModuleType>();
    private static final Map<ModuleType, Integer> operMap;
    private final ModuleData[] modules = new ModuleData[24];

    public Maq20() {
        this.modules[0] = new ModuleData();
        this.modules[0].type = ModuleType.COMM;
        this.modules[0].baseAddr = 0;
        this.setOptions(Ascii.Option.KEEP_ALIVE);
    }

    public void open(Modbus.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        super.open(type, ident, parm1, parm2);
        super.setAddressMode(true);
        try {
            this.fillModuleData();
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void setAddressMode(boolean mode) {
    }

    public short[] readRegisters(short addr, short count) throws DriverException {
        return this.readRegisters((short)0, addr, count);
    }

    public int readRegister(short addr) throws DriverException {
        return this.readRegisters((short)0, addr, (short)1)[0];
    }

    public int readRegisterPair(short addr) throws DriverException {
        short[] value = this.readRegisters((short)0, addr, (short)2);
        return value[0] << 16 | value[1] & 0xFFFF;
    }

    public void writeRegister(short addr, short value) throws DriverException {
        this.writeRegister((short)0, addr, value);
    }

    public void writeRegisters(short addr, short[] value) throws DriverException {
        this.writeRegisters((short)0, addr, value);
    }

    public void writeRegisterPair(short addr, int value) throws DriverException {
        this.writeRegisters((short)0, addr, new short[]{(short)(value >> 16), (short)value});
    }

    public boolean moduleExists(int modId) {
        return modId > 0 && modId < 24 && this.modules[modId] != null;
    }

    public String getModuleName(int modId) throws DriverException {
        short addr = (short)(this.getModuleData((int)modId, (boolean)true).baseAddr + 0);
        short[] text = this.readRegisters(addr, (short)15);
        return Maq20.makeString(text);
    }

    public ModuleType getModuleType(int modId) throws DriverException {
        return this.getModuleData((int)modId, (boolean)true).type;
    }

    public int getModuleOpType(int modId) throws DriverException {
        return this.getModuleData((int)modId, (boolean)false).opType;
    }

    public static int getModuleOpType(ModuleType modType) {
        return operMap.get((Object)modType);
    }

    public String getSerialNumber(int modId) throws DriverException {
        this.getModuleData(modId, true);
        return this.getSerialNum(modId);
    }

    public String getDateCode(int modId) throws DriverException {
        short addr = (short)(this.getModuleData((int)modId, (boolean)true).baseAddr + 31);
        short[] text = this.readRegisters(addr, (short)4);
        return Maq20.makeString(text);
    }

    public String getFwRevision(int modId) throws DriverException {
        short addr = (short)(this.getModuleData((int)modId, (boolean)true).baseAddr + 36);
        short[] text = this.readRegisters(addr, (short)4);
        return Maq20.makeString(text);
    }

    public String getIPAddress() throws DriverException {
        short[] addr = this.readRegisters((short)50, (short)4);
        return Maq20.makeIPString(addr);
    }

    public void setIPAddress(String ipAddr) throws DriverException {
        this.writeRegisters((short)50, Maq20.makeIPAddress(ipAddr));
    }

    public String getSubnetMask() throws DriverException {
        short[] addr = this.readRegisters((short)55, (short)4);
        return Maq20.makeIPString(addr);
    }

    public void setSubnetMask(String mask) throws DriverException {
        this.writeRegisters((short)55, Maq20.makeIPAddress(mask));
    }

    public double readTemperature() throws DriverException {
        return this.readRegister((short)1210);
    }

    public void saveParameters() throws DriverException {
        this.writeRegister((short)70, (short)1);
    }

    public void register(String ... serial) throws DriverException {
        ArrayList<Short> ids = new ArrayList<Short>();
        for (short j = 1; j < 24; j = (short)(j + 1)) {
            if (this.modules[j] == null) continue;
            ids.add(j);
        }
        for (String sn : serial) {
            if (sn.length() <= 10) continue;
            throw new DriverException("Serial number (" + sn + ") too long");
        }
        this.writeRegister((short)1020, (short)0);
        Iterator j = ids.iterator();
        while (j.hasNext()) {
            short id = (Short)j.next();
            this.writeRegister((short)1022, id);
        }
        short[] snId = new short[11];
        for (String sn : serial) {
            for (int j2 = 0; j2 < 10; ++j2) {
                snId[j2] = j2 < sn.length() ? (int)sn.charAt(j2) : 32;
            }
            snId[10] = (short)(snId[10] + 1);
            this.writeRegisters((short)1000, snId);
        }
        this.writeRegister((short)1021, (short)1);
        this.writeRegister((short)1020, (short)1);
        this.fillModuleData();
    }

    public int getModuleId(String serial) throws DriverException {
        short[] status = this.readRegisters((short)100, (short)24);
        for (int id = 1; id < 24; ++id) {
            if (status[id] == 0 || !serial.equals(this.getSerialNum(id))) continue;
            return id;
        }
        return -1;
    }

    public int[] getModuleIds() throws DriverException {
        short[] status = this.readRegisters((short)100, (short)24);
        int count = 0;
        for (int id = 1; id < 24; ++id) {
            count += status[id] == 0 ? 0 : 1;
        }
        int[] ids = new int[count];
        int index = 0;
        for (int id = 1; id < 24; ++id) {
            if (status[id] == 0) continue;
            ids[index++] = id;
        }
        return ids;
    }

    public int getNumInputs(int modId) throws DriverException {
        return this.getModuleData((int)modId, (boolean)false).numInChan;
    }

    public int getNumOutputs(int modId) throws DriverException {
        return this.getModuleData((int)modId, (boolean)false).numOutChan;
    }

    public Maq20AnalogIn getAnalIn(int modId) throws DriverException {
        Maq20AnalogIn access = this.getModuleData((int)modId, (boolean)false).analogIn;
        if (access == null) {
            throw new DriverException("Analog input access not available to module with id " + modId + " and type " + (Object)((Object)this.getModuleData((int)modId, (boolean)false).type));
        }
        return access;
    }

    public Maq20AnalogOut getAnalOut(int modId) throws DriverException {
        Maq20AnalogOut access = this.getModuleData((int)modId, (boolean)false).analogOut;
        if (access == null) {
            throw new DriverException("Analog output access not available to module with id " + modId + " and type " + (Object)((Object)this.getModuleData((int)modId, (boolean)false).type));
        }
        return access;
    }

    public Maq20Analog getAnalog(int modId) throws DriverException {
        Maq20Analog access = this.getModuleData((int)modId, (boolean)false).analogIn;
        if (access == null) {
            access = this.getModuleData((int)modId, (boolean)false).analogOut;
        }
        if (access == null) {
            throw new DriverException("Analog access not available to module with id " + modId + " and type " + (Object)((Object)this.getModuleData((int)modId, (boolean)false).type));
        }
        return access;
    }

    public Maq20Discrete getDiscrete(int modId) throws DriverException {
        Maq20Discrete access = this.getModuleData((int)modId, (boolean)false).discrete;
        if (access == null) {
            throw new DriverException("Discrete access not available to module with id " + modId + " and type " + (Object)((Object)this.getModuleData((int)modId, (boolean)false).type));
        }
        return access;
    }

    public Maq20DiscreteFreq getDiscFreq(int modId) throws DriverException {
        Maq20DiscreteFreq access = this.getModuleData((int)modId, (boolean)false).discFreq;
        if (access == null) {
            throw new DriverException("Discrete frequency access not available to module with id " + modId + " and type " + (Object)((Object)this.getModuleData((int)modId, (boolean)false).type));
        }
        return access;
    }

    public Maq20DiscretePulse getDiscPulse(int modId) throws DriverException {
        Maq20DiscretePulse access = this.getModuleData((int)modId, (boolean)false).discPulse;
        if (access == null) {
            throw new DriverException("Discrete pulse access not available to module with id " + modId + " and type " + (Object)((Object)this.getModuleData((int)modId, (boolean)false).type));
        }
        return access;
    }

    public Maq20DiscretePWM getDiscPWM(int modId) throws DriverException {
        Maq20DiscretePWM access = this.getModuleData((int)modId, (boolean)false).discPWM;
        if (access == null) {
            throw new DriverException("Discrete PWM access not available to module with id " + modId + " and type " + (Object)((Object)this.getModuleData((int)modId, (boolean)false).type));
        }
        return access;
    }

    private String getSerialNum(int modId) throws DriverException {
        short addr = (short)(2000 * modId + 20);
        short[] text = this.readRegisters(addr, (short)10);
        return Maq20.makeString(text);
    }

    private void fillModuleData() throws DriverException {
        short[] status = this.readRegisters((short)100, (short)24);
        for (int id = 1; id < 24; ++id) {
            if (status[id] != 0) {
                ModuleType type;
                if (this.modules[id] == null) {
                    this.modules[id] = new ModuleData();
                    this.modules[id].baseAddr = 2000 * id;
                }
                ModuleData module = this.modules[id];
                module.type = ModuleType.UNKNOWN;
                module.opType = 0;
                String name = this.getModuleName(id);
                if (name.substring(0, 6).equals("MAQ20-") && (type = typeMap.get(name.substring(6))) != null) {
                    module.type = type;
                    module.opType = operMap.get((Object)type);
                }
                module.analogIn = module.opType == 0 ? new Maq20AnalogIn(this, id) : null;
                module.analogOut = module.opType == 1 ? new Maq20AnalogOut(this, id) : null;
                module.discrete = module.opType == 2 ? new Maq20Discrete(this, id) : null;
                module.discFreq = module.opType == 2 ? new Maq20DiscreteFreq(this, id) : null;
                module.discPWM = module.opType == 2 ? new Maq20DiscretePWM(this, id) : null;
                module.discPulse = module.opType == 2 ? new Maq20DiscretePulse(this, id) : null;
                module.numInChan = this.readRegister((short)(module.baseAddr + 40));
                module.numOutChan = this.readRegister((short)(module.baseAddr + 41));
                if (module.opType != 0 && module.opType != 1) continue;
                for (int chan = 0; chan < module.numInChan + module.numOutChan; ++chan) {
                    module.range[chan] = this.readRegister((short)(module.baseAddr + 100 + chan));
                }
                this.setConversion(id);
                continue;
            }
            this.modules[id] = null;
        }
    }

    private void setConversion(int modId) throws DriverException {
        ModuleData module = this.modules[modId];
        short addr = (short)(module.baseAddr + 1700);
        int nRange = this.readRegister(addr);
        if (nRange < 0) {
            return;
        }
        module.offset = new double[nRange];
        module.scale = new double[nRange];
        for (int j = 0; j < nRange; ++j) {
            addr = (short)(module.baseAddr + 1710 + j * 20);
            short[] rData = this.readRegisters(addr, (short)20);
            double cntRange = rData[10] - rData[8];
            double mult = Math.pow(10.0, rData[4]);
            if (module.type == ModuleType.IO) {
                mult *= 0.001;
            }
            module.scale[j] = (double)(rData[2] - rData[0]) * mult / cntRange;
            module.offset[j] = (double)(rData[2] * rData[8] - rData[0] * rData[10]) * mult / cntRange;
        }
    }

    ModuleData getModuleData(int modId, boolean zeroOk) throws DriverException {
        if (!this.isOpen()) {
            throw new DriverException("Connection is not open");
        }
        ModuleData module = null;
        if (modId >= (zeroOk ? 0 : 1) && modId < 24) {
            module = this.modules[modId];
        }
        if (module == null) {
            throw new DriverException("Invalid module ID: " + modId);
        }
        return module;
    }

    private static String makeString(short[] array) {
        char elem;
        int leng;
        for (leng = array.length; leng > 0 && ((elem = (char)array[leng - 1]) == '\u0000' || elem == ' ' || elem == '\uffff'); --leng) {
        }
        char[] conv = new char[leng];
        for (int j = 0; j < leng; ++j) {
            conv[j] = (char)array[j];
        }
        return new String(conv);
    }

    private static String makeIPString(short[] array) {
        return String.format("%s.%s.%s.%s", array[0], array[1], array[2], array[3]);
    }

    private static short[] makeIPAddress(String ipAddr) throws DriverException {
        String[] elems = ipAddr.split("\\.");
        if (elems.length == 4) {
            short[] array = new short[4];
            try {
                for (int j = 0; j < 4; ++j) {
                    array[j] = Short.valueOf(elems[j]);
                }
                return array;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new DriverException("Invalid IP address string: " + ipAddr);
    }

    static {
        typeMap.put("JTC", ModuleType.JTC);
        typeMap.put("KTC", ModuleType.KTC);
        typeMap.put("TTC", ModuleType.TTC);
        typeMap.put("RSTC", ModuleType.RSTC);
        typeMap.put("RTD31", ModuleType.RTD);
        typeMap.put("MVDN", ModuleType.MVD);
        typeMap.put("VDN", ModuleType.VD);
        typeMap.put("VSN", ModuleType.VS);
        typeMap.put("IDN", ModuleType.ID);
        typeMap.put("ISN", ModuleType.IS);
        typeMap.put("VO", ModuleType.VO);
        typeMap.put("IO", ModuleType.IO);
        typeMap.put("DIOH", ModuleType.DIOH);
        typeMap.put("DIOL", ModuleType.DIOL);
        operMap = new HashMap<ModuleType, Integer>();
        operMap.put(ModuleType.JTC, 0);
        operMap.put(ModuleType.KTC, 0);
        operMap.put(ModuleType.TTC, 0);
        operMap.put(ModuleType.RSTC, 0);
        operMap.put(ModuleType.RTD, 0);
        operMap.put(ModuleType.MVD, 0);
        operMap.put(ModuleType.VD, 0);
        operMap.put(ModuleType.VS, 0);
        operMap.put(ModuleType.ID, 0);
        operMap.put(ModuleType.IS, 0);
        operMap.put(ModuleType.VO, 1);
        operMap.put(ModuleType.IO, 1);
        operMap.put(ModuleType.DIOH, 2);
        operMap.put(ModuleType.DIOL, 2);
    }

    public static enum ModuleType {
        UNKNOWN,
        COMM,
        JTC,
        KTC,
        TTC,
        RSTC,
        RTD,
        MVD,
        VD,
        VS,
        ID,
        IS,
        VO,
        IO,
        DIOH,
        DIOL;

    }

    static class ModuleData {
        ModuleType type;
        int opType;
        int baseAddr;
        Maq20AnalogIn analogIn;
        Maq20AnalogOut analogOut;
        Maq20Discrete discrete;
        Maq20DiscreteFreq discFreq;
        Maq20DiscretePulse discPulse;
        Maq20DiscretePWM discPWM;
        int numInChan;
        int numOutChan;
        int[] range = new int[16];
        double[] offset;
        double[] scale;

        ModuleData() {
        }
    }
}

