/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.focalplane.ImageDatabase;

public class ImageDatabaseService
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageDatabaseService.class.getName());
    @ConfigurationParameter(isFinal=true)
    private String dbURL;
    @ConfigurationParameter(isFinal=true)
    private boolean enabled = true;
    private ImageDatabase idb;

    public static ImageDatabaseService testInstance(String dbURL) {
        ImageDatabaseService idbs = new ImageDatabaseService();
        idbs.dbURL = dbURL;
        return idbs;
    }

    public void shutdown() {
        try {
            this.idb.close();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, "Error closeing image database", ex);
        }
    }

    public ImageDatabase getImageDatabase() {
        if (this.idb == null && this.enabled) {
            this.idb = new ImageDatabase(this.dbURL);
        }
        return this.idb;
    }
}

