/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;
import org.lsst.ccs.drivers.reb.sim.REB3Simulation;
import org.lsst.ccs.drivers.reb.sim.SequencerListener;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneConfig;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.Sequencers;
import org.lsst.ccs.subsystem.focalplane.TestFocalPlaneConfig;
import org.lsst.ccs.subsystem.focalplane.data.SequencerType;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.location.LocationSet;

public class SequencersTest {
    private static final int REB_ID = 0;
    private SequencerProc seq;
    private SequencerSimulation seqSim;
    private SequencerListener seqListener;
    private Reb reb;

    @Before
    public void setup() throws REBException {
        ClientFactorySimulation factory = new ClientFactorySimulation();
        RegClient regClient = new RegClient();
        regClient.setClientFactory((ClientFactory)factory);
        regClient.open(1, 0, "ifc");
        BaseSet bs = new BaseSet(regClient);
        this.seq = new SequencerProc(bs);
        REB3Simulation rebSim = (REB3Simulation)factory.getAddressSpaceForId(0);
        this.seqSim = rebSim.getSequencer();
        this.seqListener = new SequencerListener();
        this.seqSim.addFunctionListener((SequencerSimulation.FunctionListener)this.seqListener);
        this.seqSim.addSubroutineListener((SequencerSimulation.SubroutineListener)this.seqListener);
        this.seqSim.addStateListener((SequencerSimulation.StateListener)this.seqListener);
        FocalPlane fp = FocalPlane.createFocalPlane();
        this.reb = fp.getReb("R22/Reb1");
    }

    @Test
    public void insane() throws REBException, RaftException, IOException {
        TestFocalPlaneConfig config = TestFocalPlaneConfig.getDefaultConfig();
        config.setSequencer("sequencer-reb3.seq");
        Sequencers rebs = new Sequencers(null, (FocalPlaneConfig)config);
        rebs.add(this.reb, this.seq);
        try {
            rebs.load();
            Assert.fail((String)"Should not get here");
        }
        catch (RaftException x) {
            Assert.assertTrue((boolean)x.getMessage().contains("sanity"));
        }
    }

    @Test
    public void metaDataTest() throws IOException, RaftException {
        TestFocalPlaneConfig config = TestFocalPlaneConfig.getDefaultConfig();
        InputStream input = BootstrapResourceUtils.getBootstrapResource((String)((String)config.getSequencers().get(SequencerType.ITL)));
        FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
        FPGA2Model model = builder.compileFile(input);
        int[] registers = Sequencers.computeMetaDataRegisters((String[])config.getMetaDataRegisters(), (FPGA2Model)model);
        System.out.println(Arrays.toString(registers));
    }

    @Test
    public void focalPlaneTest() throws RaftException, REBException {
        TestFocalPlaneConfig config = TestFocalPlaneConfig.getDefaultConfig();
        FocalPlane fp = FocalPlane.createFocalPlane((String)"[R22:[ccdType:e2v],R11:[ccdType:itl]]");
        Sequencers sequencers = new Sequencers(null, (FocalPlaneConfig)config);
        sequencers.add(fp.getReb("R22/Reb0"), this.seq);
        sequencers.add(fp.getReb("R22/Reb1"), this.seq);
        sequencers.add(fp.getReb("R22/Reb2"), this.seq);
        sequencers.add(fp.getReb("R11/Reb0"), this.seq);
        sequencers.add(fp.getReb("R11/Reb1"), this.seq);
        sequencers.add(fp.getReb("R11/Reb2"), this.seq);
        sequencers.load();
        Assert.assertEquals((long)2L, (long)sequencers.getModels().size());
        Assert.assertEquals((long)1L, (long)sequencers.getRegisterMap().size());
        Assert.assertEquals((long)12L, (long)sequencers.getSequencerKeyValueData().getListOfKeyValueData().size());
    }

    @Test
    public void testClear() throws REBException, RaftException, IOException, InterruptedException {
        Sequencers rebs = this.loadSequencer();
        this.clear(1, rebs);
        this.seqListener.clear();
        this.clear(2, rebs);
    }

    @Test
    public void testRowShift() throws REBException, RaftException, IOException, InterruptedException {
        Sequencers rebs = this.loadSequencer();
        this.rowShift(2, rebs);
        Assert.assertEquals((long)1152L, (long)((Number)this.seqListener.getFunctionCounts().get(7)).intValue());
        Assert.assertEquals((long)2L, (long)((Number)this.seqListener.getFunctionCounts().get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Number)this.seqListener.getSubroutineCounts().get(144)).intValue());
        Assert.assertEquals((long)1L, (long)((Number)this.seqListener.getSubroutineReturns().get(144)).intValue());
        this.seqListener.clear();
        this.rowShift(-2, rebs);
        Assert.assertEquals((long)1152L, (long)((Number)this.seqListener.getFunctionCounts().get(7)).intValue());
        Assert.assertEquals((long)2L, (long)((Number)this.seqListener.getFunctionCounts().get(2)).intValue());
        Assert.assertEquals((long)2L, (long)((Number)this.seqListener.getSubroutineCounts().get(160)).intValue());
        Assert.assertEquals((long)1L, (long)((Number)this.seqListener.getSubroutineReturns().get(160)).intValue());
    }

    @Test
    public void testIntegration() throws REBException, RaftException, IOException, InterruptedException, TimeoutException {
        Sequencers rebs = this.loadSequencer();
        rebs.startIntegration("someName", "imageAnnotation", new LocationSet());
        Assert.assertTrue((boolean)this.seq.isRunning());
        this.seqListener.waitForState(SequencerSimulation.State.LOOPING, Duration.ofSeconds(1L));
        Assert.assertTrue((this.seqSim.getState() == SequencerSimulation.State.LOOPING ? 1 : 0) != 0);
        rebs.stop();
        this.seq.waitDone(10000);
        Assert.assertTrue((!this.seq.isRunning() ? 1 : 0) != 0);
        Assert.assertTrue((this.seqSim.getState() == SequencerSimulation.State.STOPPED ? 1 : 0) != 0);
    }

    @Test
    public void testAcquire() throws IOException, RaftException, REBException, InterruptedException, TimeoutException {
        Sequencers rebs = this.loadSequencer();
        this.seqSim.addWaveformListener((SequencerSimulation.WaveformListener)this.seqListener);
        rebs.startIntegration("someName", "someAnnotation", new LocationSet());
        this.seqListener.waitForState(SequencerSimulation.State.LOOPING, Duration.ofSeconds(1L));
        rebs.endIntegration(LSE71Commands.READOUT_MODE.FALSE);
        this.seq.waitDone(10000);
        Assert.assertTrue((!this.seq.isRunning() ? 1 : 0) != 0);
        Assert.assertTrue((this.seqSim.getState() == SequencerSimulation.State.STOPPED ? 1 : 0) != 0);
    }

    private void clear(int nClears, Sequencers rebs) throws RaftException, REBException {
        rebs.clear(nClears);
        this.seq.waitDone(10000);
        Assert.assertEquals((long)(nClears * 2048), (long)((Number)this.seqListener.getFunctionCounts().get(3)).intValue());
        Assert.assertEquals((long)(nClears * 576), (long)((Number)this.seqListener.getFunctionCounts().get(10)).intValue());
        Assert.assertEquals((long)nClears, (long)((Number)this.seqListener.getSubroutineCounts().get(304)).intValue());
        Assert.assertEquals((long)1L, (long)((Number)this.seqListener.getSubroutineReturns().get(304)).intValue());
    }

    private void rowShift(int nRows, Sequencers rebs) throws RaftException, REBException {
        rebs.rowShift(nRows);
        this.seq.waitDone(10000);
    }

    private Sequencers loadSequencer() throws IOException, RaftException, REBException {
        Sequencers sequencers = new Sequencers(null, (FocalPlaneConfig)TestFocalPlaneConfig.getDefaultConfig());
        sequencers.add(this.reb, this.seq);
        sequencers.load();
        return sequencers;
    }
}

