package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.daq.utilities.FitsServiceHeaderCommands;

/**
 * 
 * @author tonyj
 */
class FocalPlaneMetaDataCommands extends FitsServiceHeaderCommands {

    private final ImageMessageHandling imh;
    
    FocalPlaneMetaDataCommands(Agent agent, ImageMessageHandling imh) {
        super(agent);
        this.imh = imh;
    }

    @Override
    public void setNamedHeaderKeywords(String hduName, Map<String, Serializable> headersMap) {
        super.setNamedHeaderKeywords(hduName, headersMap); 
        imh.handleMetaData(headersMap);
    }
}
