/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class AbortableCountDownLatch
extends CountDownLatch {
    protected Exception abortException = null;

    public AbortableCountDownLatch(int size) {
        super(size);
    }

    public void abort(Exception x) {
        if (this.getCount() == 0L) {
            return;
        }
        this.abortException = x;
        while (this.getCount() > 0L) {
            this.countDown();
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean rtrn = super.await(timeout, unit);
        if (this.abortException != null) {
            throw new AbortedException(this.abortException);
        }
        return rtrn;
    }

    @Override
    public void await() throws InterruptedException {
        super.await();
        if (this.abortException != null) {
            throw new AbortedException(this.abortException);
        }
    }

    public static class AbortedException
    extends InterruptedException {
        public AbortedException(Exception cause) {
            super("Aborted due to exception");
            super.initCause(cause);
        }
    }
}

