/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;

public class ConfigListener
implements ConfigurationListener {
    private final FocalPlaneSubsystem subsys;
    private static final Logger LOG = Logger.getLogger(ConfigListener.class.getName());

    public ConfigListener(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    public void configurationChanged(ConfigurationInfo configurationInfo, ConfigurationListener.ConfigurationOperation configOperation) {
        if (configurationInfo.getLatestChanges().size() > 0 && configOperation != ConfigurationListener.ConfigurationOperation.SAVE) {
            List latestChanges = configurationInfo.getLatestChanges();
            boolean sequencerChanged = false;
            boolean aspicChanged = false;
            for (ConfigurationParameterInfo change : latestChanges) {
                if ("sequencer".equals(change.getParameterName())) {
                    sequencerChanged = true;
                    continue;
                }
                if (!change.getPathName().contains("ASPIC")) continue;
                aspicChanged = true;
            }
            if (sequencerChanged) {
                LOG.info("Sequencer config changed, reloading...");
                this.subsys.loadSequencers();
            }
            if (aspicChanged) {
                LOG.info("ASPIC config changed, reloading...");
                this.subsys.loadASPICS();
            }
        }
    }
}

