/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneConfig;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.SequencerData;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;

public class Sequencers {
    private static final Logger LOG = Logger.getLogger(Sequencers.class.getName());
    private static final String CLEAR_MAIN = "Clear";
    private static final String INTEGRATE_MAIN = "Integrate";
    private static final String ROW_SHIFT_R_MAIN = "RowShiftR";
    private static final String ROW_SHIFT_F_MAIN = "RowShiftF";
    private static final String READ_MAIN = "Read";
    private static final String PSEUDO_READ_MAIN = "PsuedoRead";
    private static final String[] MAINS = new String[]{"Clear", "Integrate", "RowShiftR", "RowShiftF", "Read"};
    private static final String CLEAR_COUNT_PARAMETER = "ClearCount";
    private static final String SHIFT_COUNT_PARAMETER = "ShiftCount";
    private static final String[] PARAMETERS = new String[]{"ClearCount", "ShiftCount"};
    private final Map<SequencerProc, String> REBs = new LinkedHashMap<SequencerProc, String>();
    private String imageName;
    private final FocalPlaneSubsystem subsys;
    private final FocalPlaneConfig focalPlaneConfig;
    private FPGA2Model model;
    private String sequencerName;
    private long checksum;

    Sequencers(FocalPlaneSubsystem subsys, FocalPlaneConfig focalPlaneConfig) {
        this.subsys = subsys;
        this.focalPlaneConfig = focalPlaneConfig;
    }

    void add(String path, SequencerProc seq) {
        this.REBs.put(seq, path);
    }

    public void clear(int nClears) throws REBException, RaftException {
        this.setMain(CLEAR_MAIN);
        this.setParameter(CLEAR_COUNT_PARAMETER, nClears);
        this.run(false, FocalPlaneState.READING_OUT);
    }

    public void startIntegration(String imageName) throws REBException, RaftException {
        this.imageName = imageName;
        this.setMain(INTEGRATE_MAIN);
        this.run(false, FocalPlaneState.INTEGRATING);
    }

    public void rowShift(int nRows) throws REBException, RaftException {
        if (nRows == 0) {
            return;
        }
        if (nRows > 0) {
            this.setMain(ROW_SHIFT_F_MAIN);
        } else {
            this.setMain(ROW_SHIFT_R_MAIN);
        }
        this.setParameter(SHIFT_COUNT_PARAMETER, Math.abs(nRows));
        this.run(false, FocalPlaneState.ROW_SHIFT);
    }

    public void stop() throws REBException {
        for (SequencerProc reb : this.REBs.keySet()) {
            reb.sendStop();
        }
    }

    public void endIntegration(LSE71Commands.READOUT_MODE readout) throws REBException, RaftException {
        this.stop();
        this.waitForStop(Duration.ofSeconds(1L));
        switch (readout) {
            case TRUE: {
                this.setMain(READ_MAIN);
                this.run(true, FocalPlaneState.READING_OUT);
                break;
            }
            case PSEUDO: {
                this.setMain(PSEUDO_READ_MAIN);
                this.run(false, FocalPlaneState.READING_OUT);
                break;
            }
        }
    }

    private void setMain(String mainName) throws REBException, RaftException {
        for (SequencerProc reb : this.REBs.keySet()) {
            reb.setStart(mainName);
        }
    }

    private void setParameter(String parameter, int value) throws REBException, RaftException {
        for (SequencerProc reb : this.REBs.keySet()) {
            reb.setParameter(parameter, value);
        }
    }

    private void run(boolean acquire, FocalPlaneState stateOnSuccess) throws REBException {
        if (acquire) {
            this.subsys.getGlobalProc().acquireImage(this.imageName);
        } else {
            for (SequencerProc reb : this.REBs.keySet()) {
                reb.startSequencer();
            }
        }
        this.setState(stateOnSuccess);
        this.doInBackground(() -> {
            try {
                this.waitForStop(Duration.ofMillis(1000000000L));
                this.setState(FocalPlaneState.QUIESCENT);
                LOG.info("Sequencers finished");
            }
            catch (REBException ex) {
                LOG.log(Level.SEVERE, "Error waiting for REBs", ex);
            }
        });
    }

    public void waitForStop(Duration timeout) throws REBException {
        for (SequencerProc reb : this.REBs.keySet()) {
            reb.waitDone((int)timeout.toMillis());
            int errorAddr = reb.getErrorAddr();
            if (errorAddr == -1) continue;
            LOG.log(Level.SEVERE, "REB error register set to {0} for {1}", new Object[]{errorAddr, this.REBs.get(reb)});
        }
    }

    private static void sanityCheck(FPGA2Model model) throws RaftException, REBException {
        Map mainMap = model.getMainAddresses();
        for (String main : MAINS) {
            if (mainMap.get(main) != null) continue;
            throw new RaftException("Sequencer failed sanity check, missing main " + main);
        }
        List pointers = model.getPointers();
        for (String parameter : PARAMETERS) {
            boolean found = false;
            for (FPGA2Model.PointerInfo pointer : pointers) {
                if (!pointer.getName().equals(parameter)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new RaftException("Sequencer failed sanity check, missing parameter " + parameter);
        }
    }

    static int[] computeMetaDataRegisters(String[] metaDataNames, FPGA2Model model) throws RaftException {
        int[] registers = new int[metaDataNames.length];
        Map pointerMap = model.getPointerMap();
        int k = 0;
        block4: for (String metaName : metaDataNames) {
            FPGA2Model.PointerInfo pi = (FPGA2Model.PointerInfo)pointerMap.get(metaName);
            if (pi != null) {
                switch (pi.getKind()) {
                    case REPEAT_FUNCTION: {
                        registers[k++] = pi.getAddress();
                        continue block4;
                    }
                    case REPEAT_SUBROUTINE: {
                        registers[k++] = pi.getAddress();
                        continue block4;
                    }
                    default: {
                        throw new RaftException("Parameter: " + metaName + " is of unsupported type " + pi.getKind());
                    }
                }
            }
            throw new RaftException("Required parameter not defined " + metaName);
        }
        return registers;
    }

    static FPGA2Model validate(String sequencerFile) throws RaftException, REBException, IOException {
        InputStream input = BootstrapResourceUtils.getBootstrapResource((String)sequencerFile);
        if (input == null) {
            throw new IOException("Invalid sequencer file name " + sequencerFile);
        }
        FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
        FPGA2Model compiledModel = builder.compileFile(input);
        Sequencers.sanityCheck(compiledModel);
        return compiledModel;
    }

    void load() throws RaftException, REBException {
        try {
            this.model = Sequencers.validate(this.focalPlaneConfig.getSequencer());
            this.sequencerName = this.focalPlaneConfig.getSequencer();
            this.checksum = this.model.computeCheckSum();
            int[] registers = Sequencers.computeMetaDataRegisters(SequencerData.imageRegNames, this.model);
            if (this.subsys != null) {
                this.subsys.getGlobalProc().setRegisters(0, registers);
            }
            KeyValueDataList data = new KeyValueDataList();
            AtomicInteger n = new AtomicInteger(0);
            this.REBs.forEach((sequencer, path) -> {
                try {
                    sequencer.loadSequencer(this.model);
                    n.incrementAndGet();
                    data.addData(path + "/sequencerFile", (Serializable)((Object)this.sequencerName));
                    data.addData(path + "/sequencerChecksum", (Serializable)((Object)String.valueOf(this.checksum)));
                }
                catch (REBException ex) {
                    LOG.log(Level.WARNING, "Unable to load sequencer " + this.sequencerName + " into " + path, ex);
                }
            });
            if (this.subsys != null) {
                this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
            }
            LOG.log(Level.INFO, "Loading sequencer {0} into {1} sequencers", new Object[]{this.focalPlaneConfig.getSequencer(), n});
        }
        catch (IOException x) {
            RaftException re = new RaftException("Error reading sequencer " + this.focalPlaneConfig.getSequencer());
            re.initCause((Throwable)x);
            throw re;
        }
    }

    private void doInBackground(Runnable run) {
        Thread t = new Thread(run);
        t.setName("Sequencer wait thread");
        t.start();
    }

    private void setState(FocalPlaneState focalPlaneState) {
        if (this.subsys != null) {
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{focalPlaneState});
        }
    }

    void load(SequencerProc sequencer) {
        if (this.model != null) {
            String path = this.REBs.get(sequencer);
            try {
                KeyValueDataList data = new KeyValueDataList();
                sequencer.loadSequencer(this.model);
                LOG.log(Level.INFO, "Loading sequencer {0} into REB {1}", new Object[]{this.sequencerName, path});
                data.addData(path + "/sequencerFile", (Serializable)((Object)this.sequencerName));
                data.addData(path + "/sequencerChecksum", (Serializable)((Object)String.valueOf(this.checksum)));
                if (this.subsys != null) {
                    this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)data);
                }
            }
            catch (REBException ex) {
                LOG.log(Level.SEVERE, "Unable to load sequencer into " + path, ex);
            }
        }
    }
}

