/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.apcpdu.AP7900;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class TestAP7900 {
    protected AP7900 mydev;
    private final Thread readW = new Thread(new Reader());
    private int last_state = -1;
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean open;

    @Command(name="open", description="Open an FTDI cnx to the PDU")
    public void open(@Argument(name="devId", description="The device ID of the device to open") String MyDevId) throws DriverException {
        this.mydev = new AP7900();
        this.mydev.openftdi(MyDevId, 9600, 3);
    }

    @Command(name="openserial", description="Open a serial connection to the PDU using default addr")
    public void openserial() throws DriverException {
        this.openserial("/dev/ttyS1");
    }

    @Command(name="openserial", description="Open a serial connection to the PDU")
    public void openserial(@Argument(name="devId", description="The device ID of the device to open") String MyDevId) throws DriverException {
        this.mydev = new AP7900();
        this.mydev.openserial(MyDevId, 9600);
    }

    @Command(name="opennet", description="Open a network connection to the PDU using default addr")
    public void opennet() throws DriverException {
        this.opennet("130.199.47.27", 23);
    }

    @Command(name="opennet", description="Open a network connection to the PDU")
    public void opennet(@Argument(name="netaddr", description="The netaddr of the device to open - 130.199.47.172") String MyNetAddr, @Argument(name="port", description="port - 23") int port) throws DriverException {
        this.mydev = new AP7900();
        this.mydev.opennet(MyNetAddr, port, 3);
        this.open = true;
        this.mydev.setTimeout(60);
        this.readW.setDaemon(true);
        this.readW.start();
    }

    @Command(name="close", description="Close the device")
    public void close() throws Exception {
        this.mydev.close();
    }

    @Command(name="ison", description="is the outlet on")
    public boolean ison(@Argument(name="outlet", description="outlet number") int outlet) throws Exception {
        this.mydev.isOutletOn(outlet);
        this.last_state = -1;
        for (int i = 0; i < 200; ++i) {
            System.out.println("Waiting for a response from the PDU");
            Thread.sleep(1000L);
            if (this.last_state >= 0) break;
        }
        if (this.last_state < 0) {
            throw new DriverException("PDU never responded to outlet state request");
        }
        return this.last_state == 1;
    }

    @Command(name="setoutlet", description="set state of outlet")
    public void setoutlet(@Argument(name="outlet", description="outlet number") int outlet, @Argument(name="state", description="state to set") boolean state) throws Exception {
        this.mydev.setOutletState(outlet, state);
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            while (TestAP7900.this.open) {
                try {
                    String reply = TestAP7900.this.mydev.read();
                    if (reply.indexOf("State") >= 0) {
                        TestAP7900.this.last_state = 0;
                        if (reply.indexOf("ON") >= 0) {
                            TestAP7900.this.last_state = 1;
                        }
                    }
                    System.out.println(reply);
                    TestAP7900.this.nRead++;
                    TestAP7900.this.nByte = TestAP7900.this.nByte + reply.length();
                }
                catch (DriverTimeoutException e) {
                    TestAP7900.this.nTimeout++;
                }
                catch (DriverException e) {
                    if (!TestAP7900.this.open) continue;
                    System.out.println((Object)e);
                    System.exit(0);
                }
            }
        }
    }
}

