/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;

public class LSE71Commands {
    private final FocalPlaneSubsystem subsys;

    LSE71Commands(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    @Command(type=Command.CommandType.ACTION, description="Perform a clear operation", level=0, autoAck=false)
    public void clear(int nClears) {
        this.subsys.helper().precondition(nClears > 0 && nClears <= 15, "Invalid nClears: %d", new Object[]{nClears}).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.subsys.getSequencers().clear(nClears));
    }

    @Command(type=Command.CommandType.ACTION, description="Start integration", level=0, autoAck=false)
    public ImageName startIntegration() {
        return (ImageName)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT}).precondition(this.subsys.getImageNameService() != null, "Image name service not available", new Object[0]).enterFaultOnException(true).action(() -> {
            ImageName in = this.subsys.getImageNameService().getImageName();
            this.subsys.getSequencers().startIntegration(in.toString());
            return in;
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Start integration", level=0, autoAck=false)
    public ImageName startIntegration(ImageName name) {
        return (ImageName)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT}).precondition(this.subsys.getImageNameService() != null, "Image name service not available", new Object[0]).enterFaultOnException(true).action(() -> {
            this.subsys.getSequencers().startIntegration(name.toString());
            return name;
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Shift n rows", level=0, autoAck=false)
    public void shiftNRows(int nRows) {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.INTEGRATING}).enterFaultOnException(true).action(() -> this.subsys.getSequencers().rowShift(nRows));
    }

    @Command(type=Command.CommandType.ACTION, description="End exposure, and optionally read out", level=0, autoAck=false)
    public void endIntegration(@Argument(defaultValue="TRUE") READOUT_MODE readout) {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.INTEGRATING}).enterFaultOnException(true).action(() -> {
            this.subsys.getImageHandling().clearWait();
            this.subsys.getSequencers().endIntegration(readout);
        });
    }

    public static enum READOUT_MODE {
        TRUE,
        FALSE,
        PSEUDO;

    }
}

