/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.utilities.FitsServiceHeaderCommands;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.focalplane.ConfigListener;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneConfig;
import org.lsst.ccs.subsystem.focalplane.HardwareIdConfiguration;
import org.lsst.ccs.subsystem.focalplane.ImageHandling;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.ScriptingCommands;
import org.lsst.ccs.subsystem.focalplane.Sequencers;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.RaftsCommands;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.states.RebDeviceState;
import org.lsst.ccs.subsystem.rafts.states.RebValidationState;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;

public class FocalPlaneSubsystem
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, REBDevice> rebDevices = new HashMap<String, REBDevice>();
    private Sequencers sequencers;
    private final Map<String, RaftsCommands> raftsCommands = new HashMap<String, RaftsCommands>();
    private final FocalPlane focalPlaneGeometry;
    private ImageHandling imageHandling;
    private static final Logger LOG = Logger.getLogger(FocalPlaneSubsystem.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private GlobalProc globalProc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private FocalPlaneConfig focalPlaneConfig;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageNameService imageNameService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Agent agent;
    private ComponentLookup lookupService;
    private long lastClear;

    public FocalPlaneSubsystem(FocalPlane geometry) {
        super("fp", AgentInfo.AgentType.WORKER);
        this.focalPlaneGeometry = geometry;
    }

    public void build() {
        this.setAgentProperty("org.lsst.ccs.use.full.paths", "true");
        this.setAgentProperty("agentCategory", AgentCategory.FOCAL_PLANE.name());
        this.lookupService = this.agent.getComponentLookup();
        ComponentNode thisComponent = this.lookupService.getComponentNodeForObject((Object)this);
        for (Raft r : this.focalPlaneGeometry.getChildrenList()) {
            ComponentNode raftNode = new ComponentNode(r.getName(), (Object)new HardwareIdConfiguration());
            this.lookupService.addComponentNodeToLookup(thisComponent, raftNode);
            for (Reb reb : r.getChildrenList()) {
                String rebName = r.getName() + "/" + reb.getName();
                ComponentNode rebComponent = this.lookupService.getNodeByPath(rebName);
                for (int j = 0; j < 3; ++j) {
                    String sensorName = "S" + reb.getParallelPosition() + j;
                    ComponentNode sensorNode = new ComponentNode(sensorName, (Object)new HardwareIdConfiguration());
                    this.lookupService.addComponentNodeToLookup(rebComponent, sensorNode);
                }
            }
        }
    }

    public void postInit() {
        this.sequencers = new Sequencers(this, this.focalPlaneConfig);
        this.imageHandling = new ImageHandling(this, this.focalPlaneConfig);
        this.updateAgentState(new Enum[]{FocalPlaneState.NEEDS_CLEAR});
        for (Raft raft : this.focalPlaneGeometry.getChildrenList()) {
            String raftName = raft.getName();
            ArrayList raftRebDevices = new ArrayList();
            this.rebDevices.forEach((rebName, device) -> {
                if (rebName.startsWith(raftName)) {
                    raftRebDevices.add(device);
                    this.sequencers.add(this.lookupService.getComponentNodeForObject(device).getPath(), device.getSequencer());
                    ImageProc imageProc = device.getImageProc();
                    imageProc.setPatternProperty("raftName", raftName);
                    this.imageHandling.addImageProc(imageProc);
                }
            });
            RaftsCommands commands = new RaftsCommands((Subsystem)this, raftRebDevices, this.globalProc, (Geometry)raft, null);
            this.raftsCommands.put(raftName, commands);
            this.addCommandsFromObject(commands, raftName);
        }
        this.agentStateService.addStateChangeListener((device, newState, oldState) -> {
            if (newState == RebValidationState.VALID) {
                REBDevice rebDevice = (REBDevice)device;
                this.sequencers.load(rebDevice.getSequencer());
                try {
                    Integer result = rebDevice.loadAspics(true);
                    LOG.log(Level.INFO, "Loaded aspics for {0} result {1}", new Object[]{rebDevice.getFullName(), result});
                }
                catch (Exception x) {
                    LOG.log(Level.WARNING, "Exception while loading ASPICS", x);
                }
            }
        }, new Class[]{RebDeviceState.class, RebValidationState.class});
        this.addCommandsFromObject(new LSE71Commands(this), "");
        this.addCommandsFromObject(new ScriptingCommands(this), "");
        FitsServiceHeaderCommands fitsServiceHeaderCommands = new FitsServiceHeaderCommands((Agent)this);
        this.addCommandsFromObject(fitsServiceHeaderCommands, "");
        this.agentStateService.addStateChangeListener((changedObj, newState, oldState) -> {
            if (newState == FocalPlaneState.QUIESCENT && (oldState == FocalPlaneState.CLEARING || oldState == FocalPlaneState.READING_OUT)) {
                this.lastClear = System.currentTimeMillis();
            } else if (newState == FocalPlaneState.READING_OUT) {
                double darkTime = (double)(System.currentTimeMillis() - this.lastClear) / 1000.0;
                LOG.log(Level.INFO, "Setting darktime to {0}", darkTime);
                fitsServiceHeaderCommands.setHeaderKeyword("DarkTime", (Serializable)Double.valueOf(darkTime));
            }
        }, new Class[]{FocalPlaneState.class});
    }

    public void preStart() {
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            FocalPlaneDataGroup dataGroup = FocalPlaneDataGroup.findFocalPlanDataGroup((DataProviderInfo)data);
            if (dataGroup == null) continue;
            dataGroup.addAttributesToDataInfo(data);
        }
    }

    public void postStart() {
        this.configService.addConfigurationListener((ConfigurationListener)new ConfigListener(this));
        this.loadSequencers();
    }

    void loadSequencers() {
        try {
            this.sequencers.load();
        }
        catch (REBException | RaftException x) {
            throw new RuntimeException("Error configuring sequencers", x);
        }
    }

    void loadASPICS() {
        for (REBDevice device : this.rebDevices.values()) {
            if (!device.isOnline() || !device.isSerialNumValid()) continue;
            try {
                Integer result = device.loadAspics(true);
                LOG.log(Level.INFO, "Loaded aspics for {0} result {1}", new Object[]{device.getFullName(), result});
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Error while loading ASPICS", ex);
            }
        }
    }

    public Sequencers getSequencers() {
        return this.sequencers;
    }

    GlobalProc getGlobalProc() {
        return this.globalProc;
    }

    ImageNameService getImageNameService() {
        return this.imageNameService;
    }

    ImageHandling getImageHandling() {
        return this.imageHandling;
    }
}

