package org.lsst.ccs.subsystem.focalplane;

import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;

/**
 *
 * @author tonyj
 */
public class ConfigListener implements ConfigurationListener {

    private final FocalPlaneSubsystem subsys;
    private static final Logger LOG = Logger.getLogger(ConfigListener.class.getName());

    public ConfigListener(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    @Override
    public void configurationChanged(ConfigurationInfo configurationInfo, ConfigurationOperation configOperation) {
        if (configurationInfo.getLatestChanges().size() > 0 && configOperation != ConfigurationOperation.SAVE) {
            List<ConfigurationParameterInfo> latestChanges = configurationInfo.getLatestChanges();
            boolean sequencerChanged = false;
            boolean aspicChanged = false;
            for (ConfigurationParameterInfo change : latestChanges) {
                if ("sequencer".equals(change.getParameterName())) {
                    sequencerChanged = true;
                } else if (change.getPathName().contains("ASPIC")) {
                    aspicChanged = true;
                }
            }
            if (sequencerChanged) {
                LOG.info("Sequencer config changed, reloading...");
                subsys.loadSequencers();
            }
            if (aspicChanged) {
                LOG.info("ASPIC config changed, reloading...");
                subsys.loadASPICS();
            }
        }
    }

}
