/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Header;
import org.jgroups.util.Util;

public class SaslHeader
extends Header {
    private Type type;
    private byte[] payload;

    public SaslHeader() {
    }

    public SaslHeader(Type type, byte[] payload) {
        this.type = type;
        this.payload = payload;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public SaslHeader payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public byte[] token() {
        return this.payload;
    }

    public SaslHeader type(Type type) {
        this.type = type;
        return this;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeByte(this.type.ordinal());
        Util.writeByteBuffer(this.payload, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.type = Type.values()[in.readByte()];
        this.payload = Util.readByteBuffer(in);
    }

    @Override
    public int size() {
        return Util.size(this.payload);
    }

    @Override
    public String toString() {
        return "payload=" + this.payload;
    }

    public static enum Type {
        CHALLENGE,
        RESPONSE;

    }
}

