/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinator;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinatorUtilities;
import org.lsst.ccs.subsystem.focalplane.ImageDatabase;
import org.lsst.ccs.subsystem.focalplane.ImageDatabaseService;
import org.lsst.ccs.subsystem.focalplane.ImageDatabaseTest;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.FitsFilesWrittenEvent;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageCoordinatorTest {
    @BeforeClass
    public static void setupClass() {
        System.setProperty("org.lsst.ccs.run.mode", "simulation");
    }

    @Test
    public void imageCoordinatorTest() throws DAQException, InterruptedException {
        Store store = new Store("test");
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)ImageDatabaseTest.createConnection());
        ImageName imageName = new ImageName("CC_C_20200704_0000001");
        ImageDatabase imd = idbs.getImageDatabase();
        ImageCoordinator coordinator = new ImageCoordinator(imageName, (ImageCoordinatorUtilities)new TestStateMachine(), null, imd, 1);
        coordinator.startIntegration("annotation", LocationSet.of((String[])new String[]{"R22"}), null);
        Thread.sleep(500L);
        ImageMetaData meta = new ImageMetaData("name", "raw", "annotation", 7, (Set)LocationSet.of((String[])new String[]{"R22"}));
        Image triggeredImage = store.getCamera().triggerImage(meta);
        coordinator.endIntegration(LSE71Commands.ReadoutMode.TRUE, triggeredImage);
        coordinator.imageCreated(triggeredImage);
        coordinator.imageComplete(triggeredImage);
        FileList fileList = new FileList();
        fileList.add((Object)new File("/tmp/sometest.fits"));
        FitsFilesWrittenEvent ffe = new FitsFilesWrittenEvent(imageName.toString(), fileList, LocationSet.of((String[])new String[]{"R22"}));
        coordinator.addFitsFiles(ffe);
    }

    static class TestStateMachine
    implements ImageCoordinatorUtilities {
        TestStateMachine() {
        }

        public void sendEvent(String key, Serializable event) {
            System.out.printf("Sending ...%s\n", event);
        }

        public void setStateIf(FocalPlaneState focalPlaneState, FocalPlaneState focalPlaneState0) {
        }

        public void done(ImageCoordinator ic) {
        }
    }
}

