/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;

public class FocalPlaneSubsystemTest {
    private static FocalPlaneSubsystem testSubsystem;
    private static Agent console;

    @BeforeAll
    public static void createSubsystem() throws Exception {
        System.setProperty("org.lsst.ccs.transport", "mock:single");
        System.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.logging.StackTraceFormats.depth", "-1");
        testSubsystem = (FocalPlaneSubsystem)BootUtils.getSubsystemFromFile((String)"FocalPlane", null, (String)"focal-plane-sim");
        testSubsystem.startAgent();
        AgentStateService agentService = (AgentStateService)testSubsystem.getAgentService(AgentStateService.class);
        console = new Agent("console", AgentInfo.AgentType.CONSOLE);
        console.startAgent();
        Assertions.assertTrue((boolean)testSubsystem.getMessagingAccess().getAgentPresenceManager().waitForAgent(console.getName(), 30L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)console.getMessagingAccess().getAgentPresenceManager().waitForAgent(testSubsystem.getName(), 30L, TimeUnit.SECONDS));
    }

    @AfterAll
    public static void shutdownSubsystem() throws Exception {
        if (testSubsystem != null) {
            testSubsystem.shutdownAgent();
        }
        if (console != null) {
            console.shutdownAgent();
        }
        System.setProperty("org.lsst.ccs.run.mode", "");
        System.setProperty("org.lsst.ccs.drivers.reb.sim.REBType", "");
    }

    @Test
    public void testWriteFitsFiles() throws Exception {
        AgentStateService agentService = (AgentStateService)testSubsystem.getAgentService(AgentStateService.class);
        Assertions.assertTrue((boolean)agentService.isInState((Enum)FocalPlaneState.NEEDS_CLEAR));
        CommandRequest cmd = new CommandRequest(testSubsystem.getName(), "clear 1");
        MyCommandOriginator cmdOrig = new MyCommandOriginator();
        console.getMessagingAccess().sendCommandRequest(cmd, (CommandOriginator)cmdOrig);
        Assertions.assertTrue((boolean)agentService.waitFor(t -> t.isInState((Enum)FocalPlaneState.QUIESCENT), 10L, TimeUnit.SECONDS));
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(console.getMessagingAccess());
        cmd = new CommandRequest(testSubsystem.getName(), "startIntegration");
        Object imageName = cmu.sendSynchronousCommand(cmd);
        Assertions.assertNotNull((Object)imageName);
        System.out.println(imageName);
        Assertions.assertTrue((boolean)agentService.waitFor(t -> t.isInState((Enum)FocalPlaneState.INTEGRATING), 10L, TimeUnit.SECONDS));
        cmd = new CommandRequest(testSubsystem.getName(), "endIntegration");
        cmu.sendSynchronousCommand(cmd);
        Assertions.assertTrue((boolean)agentService.waitFor(t -> t.isInState((Enum)FocalPlaneState.QUIESCENT), 10L, TimeUnit.SECONDS));
    }

    class MyCommandOriginator
    implements CommandOriginator {
        MyCommandOriginator() {
        }

        public void processAck(CommandAck ack) {
            System.out.println("Ack!!!");
        }

        public void processNack(CommandNack nack) {
            System.out.println("Nack!!!");
        }

        public void processResult(CommandResult result) {
            System.out.println("Got result!!!" + result);
        }
    }
}

