/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function.examples;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IFitData;
import hep.aida.IFitFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotter;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.function.NonParametricFunction;
import java.util.Random;

public class NonParametricUnbinnedFit {
    public static void main(String[] args) {
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plotter");
        ICloud1D c1 = histogramFactory.createCloud1D("Cloud 1D");
        Random r_1 = new Random(123L);
        Random r_2 = new Random(456L);
        for (int i = 0; i < 1000; ++i) {
            double x = r_1.nextGaussian();
            c1.fill(x);
        }
        IFitData data = fitFactory.createFitData();
        data.create1DConnection(c1);
        NonParametricFunction f = new NonParametricFunction("Non Parametric Function", data);
        plotter.show();
        plotter.region(0).plot((IBaseHistogram)c1);
        plotter.region(0).plot((IFunction)f);
    }
}

