/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.Aspic;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

public class AspicControl
extends Control {
    static final String RC = "rc";
    static final String GAIN = "gain";
    static final String CLAMP = "clamp";
    static final String AF1 = "af1";
    static final String TM = "tm";
    private static final int GAIN_RC_CH = 1;
    private static final int CLAMP_CH = 2;
    private static final int MODE_CH = 4;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupPath
    String aspicPath;
    @ConfigurationParameter(name="gain", category="Rafts", description="Gain Selector", units="DAC counts")
    private volatile int gain;
    @ConfigurationParameter(name="rc", category="Rafts", description="RC Selector", units="DAC counts")
    private volatile int rc;
    @ConfigurationParameter(name="clamp", category="Rafts", description="Clamp bits", units="DAC counts")
    private volatile int clamp;
    @ConfigurationParameter(name="af1", category="Rafts", description="First Stage Gain", units="DAC counts")
    private volatile int af1;
    @ConfigurationParameter(name="tm", category="Rafts", description="Transparent mode", units="DAC counts")
    private volatile int tm;
    private static final Logger LOG = Logger.getLogger(AspicControl.class.getName());
    private Aspic asp;
    private int hwVersion;
    private int change = -1;

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.asp = ((REBDevice)devc).getAspic();
    }

    public boolean checkConfig() {
        this.hwVersion = AspicControl.getHwVersion(this.asp);
        if (this.hwVersion == -1) {
            LOG.log(Level.SEVERE, "ASPIC {0} configuration not supported by the firmware", this.hwChan);
            return false;
        }
        try {
            if (this.hwChan >= 0 && this.hwChan < 2 * this.asp.getNumStrips()) {
                return true;
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting number of strips");
            return false;
        }
        try {
            LOG.log(Level.SEVERE, "{0} configuration parameter {1} {2}", new Object[]{this.aspicPath, "HW channel", this.hwChan});
            throw new RuntimeException("Fatal configuration error");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getHwVersion(Aspic asp) {
        return asp.getVersion() == -1 ? -1 : 0;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    @ConfigurationParameterChanger
    public void setGain(int value) {
        this.gain = value;
        this.change |= 1;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the gain")
    public int getGain() {
        return this.gain;
    }

    @ConfigurationParameterChanger
    public void setRc(int value) {
        this.rc = value;
        this.change |= 1;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the rc value")
    public int getRc() {
        return this.rc;
    }

    @ConfigurationParameterChanger
    public void setClamp(int value) {
        this.clamp = value;
        this.change |= 2;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the clamp")
    public int getClamp() {
        return this.clamp;
    }

    @ConfigurationParameterChanger
    public void setAf1(int value) {
        this.af1 = value;
        this.change |= 4;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the af1 value")
    public int getAf1() {
        return this.af1;
    }

    @ConfigurationParameterChanger
    public void setTm(int value) {
        this.tm = value;
        this.change |= 4;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the tm")
    public int getTm() {
        return this.tm;
    }

    void setConfig(ASPIC aspic) {
        this.sce.change(this.aspicPath, GAIN, (Object)aspic.getGain());
        this.sce.change(this.aspicPath, RC, (Object)aspic.getRc());
        this.sce.change(this.aspicPath, CLAMP, (Object)aspic.getClamp());
        this.sce.change(this.aspicPath, AF1, (Object)(aspic.isAf1() ? 1 : 0));
        this.sce.change(this.aspicPath, TM, (Object)(aspic.isTm() ? 1 : 0));
    }

    ASPIC getConfig() {
        ASPIC aspic = new ASPIC();
        aspic.setGain(this.gain);
        aspic.setRc(this.rc);
        aspic.setClamp(this.clamp);
        aspic.setAf1(this.af1 != 0);
        aspic.setTm(this.tm != 0);
        return aspic;
    }

    int load() throws Exception {
        if (this.asp.getVersion() == -1) {
            return 0;
        }
        try {
            int strips = 1 << this.hwChan / 2;
            int side = (this.hwChan & 1) == 0 ? 0 : 1;
            this.asp.writeGainRc(strips, 1 << side, this.gain, this.rc);
            this.asp.writeClamp(strips, 1 << side, this.clamp);
            int mode = (this.af1 != 0 ? 2 : 0) | (this.tm != 0 ? 1 : 0);
            this.asp.writeModes(strips, 1 << side, mode);
            this.change = 0;
            return 1;
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
            return 0;
        }
    }

    int loadChanged() throws Exception {
        if (this.asp.getVersion() == -1) {
            return 0;
        }
        int count = 0;
        if (this.change != 0) {
            try {
                int side;
                int strips = 1 << this.hwChan / 2;
                int n = side = (this.hwChan & 1) == 0 ? 0 : 1;
                if ((this.change & 1) != 0) {
                    this.asp.writeGainRc(strips, 1 << side, this.gain, this.rc);
                }
                if ((this.change & 2) != 0) {
                    this.asp.writeClamp(strips, 1 << side, this.clamp);
                }
                if ((this.change &= 4) != 0) {
                    int mode = (this.af1 != 0 ? 2 : 0) | (this.tm != 0 ? 1 : 0);
                    this.asp.writeModes(strips, 1 << side, mode);
                }
                count = 1;
                this.change = 0;
            }
            catch (REBException e) {
                this.checkTimeout((Exception)((Object)e), RaftException.class);
            }
        }
        return count;
    }

    int check() throws Exception {
        if (this.asp.getVersion() == -1) {
            return 0;
        }
        try {
            int mask = 0;
            int strips = 1 << this.hwChan / 2;
            int side = (this.hwChan & 1) == 0 ? 0 : 1;
            int[][] values = this.asp.readGainRc(strips, side);
            if (values[0][0] != this.gain) {
                mask |= 1;
            }
            if (values[0][1] != this.rc) {
                mask |= 2;
            }
            values[0] = this.asp.readClamp(strips, side);
            if (values[0][0] != this.clamp) {
                mask |= 4;
            }
            values[0] = this.asp.readModes(strips, side);
            int value = values[0][0] & 3;
            if (value != ((this.af1 != 0 ? 2 : 0) | (this.tm != 0 ? 1 : 0))) {
                mask |= 8;
            }
            return mask;
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
            return 0;
        }
    }

    int reset() throws Exception {
        if (this.asp.getVersion() == -1) {
            return 0;
        }
        try {
            this.asp.reset(this.hwChan / 2);
            return 2;
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
            return 0;
        }
    }
}

