/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.channel.Decompress18BitChannel;
import org.lsst.ccs.daq.ims.channel.DemultiplexingIntChannel;
import org.lsst.ccs.daq.ims.channel.FitsAsyncWriteChannel;
import org.lsst.ccs.daq.ims.channel.ReadoutConfig;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;
import org.lsst.ccs.daq.ims.channel.XORWritableIntChannel;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.readout.GeometryFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.readout.PropertiesFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.readout.ReadOutImageSet;
import org.lsst.ccs.utilities.readout.ReadOutParameters;
import org.lsst.ccs.utilities.readout.ReadOutParametersBuilder;
import org.lsst.ccs.utilities.readout.ReadOutParametersNew;

public class FitsIntWriter
implements WritableIntChannel {
    private static final DateTimeFormatter DATE_FORMAT;
    private Decompress18BitChannel decompress;
    private final FitsFileWriter[] writers;
    private final File[] files;
    private final Map<String, Object> props;
    private final Reb reb;

    public FitsIntWriter(Image image, Reb reb, FileNamer fileNamer) throws IOException {
        Location location = reb.getLocation();
        int ccdCount = location.type().getCCDCount();
        this.files = new File[location.type() == Location.LocationType.WAVEFRONT ? 2 : ccdCount];
        this.writers = new FitsFileWriter[this.files.length];
        this.reb = reb;
        ReadoutConfig readoutConfig = new ReadoutConfig(location.type());
        this.props = new HashMap<String, Object>();
        try {
            ImageName in = new ImageName(image.getMetaData().getName());
            this.props.put("ImageName", in.toString());
            this.props.put("ImageDate", in.getDateString());
            this.props.put("ImageNumber", in.getNumberString());
            this.props.put("ImageController", in.getController().getCode());
            this.props.put("ImageSource", in.getSource().getCode());
        }
        catch (IllegalArgumentException x) {
            this.props.put("ImageName", image.getMetaData().getName());
            this.props.put("ImageDate", DATE_FORMAT.format(image.getMetaData().getTimestamp()));
        }
        this.props.put("FileCreationTime", new Date());
        this.props.put("RaftBay", location.getRaftName());
        this.props.put("RebSlot", location.getBoardName());
        this.props.put("DAQPartition", image.getStore().getPartition());
        this.props.put("DAQFolder", image.getMetaData().getCreationFolderName());
        this.props.put("DAQAnnotation", image.getMetaData().getAnnotation());
        try {
            for (int i = 0; i < this.files.length; ++i) {
                int sensorIndex = readoutConfig.getDataSensorMap()[i];
                HashMap<String, Object> ccdProps = new HashMap<String, Object>();
                ccdProps.putAll(this.props);
                ccdProps.put("CCDSlot", location.getSensorName(sensorIndex));
                this.files[i] = fileNamer.computeFileName(ccdProps);
                this.writers[i] = new FitsFileWriter(this.files[i]);
            }
        }
        catch (IOException | RuntimeException t) {
            this.cleanupOnError(location, t);
        }
    }

    private void cleanupOnError(Location location, Exception t) throws IOException {
        for (FitsFileWriter fitsFileWriter : this.writers) {
            if (fitsFileWriter == null) continue;
            try {
                fitsFileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (File file : this.files) {
            if (file == null) continue;
            file.delete();
        }
        throw new IOException("Error writing FITS files for location " + location, t);
    }

    public final void completeInitialization(Source source, Map<String, HeaderSpecification> headerSpecifications, PerCCDMetaDataProvider extraMetaDataProvider) throws DAQException, IOException {
        SourceMetaData smd = source.getMetaData();
        this.props.put("DAQTriggerTime", source.getImage().getMetaData().getTimestamp());
        this.props.put("Tag", String.format("%x", source.getImage().getMetaData().getId()));
        this.props.put("Firmware", String.format("%x", smd.getFirmware()));
        this.props.put("Platform", smd.getPlatform());
        this.props.put("CCDControllerSerial", String.format("%x", smd.getSerialNumber() & 0xFFFFFFFFL));
        this.props.put("DAQVersion", smd.getSoftware().toString());
        int[] registerValues = smd.getRegisterValues();
        ReadOutParametersBuilder builder = ReadOutParametersBuilder.create();
        builder.readoutParameterValues(registerValues);
        builder.readoutParameterNames(ReadOutParametersNew.DEFAULT_NAMES);
        ReadOutParameters readoutParameters = builder.build();
        if (source.getSourceType() == Location.LocationType.SCIENCE) {
            this.reb.setCCDType(readoutParameters.getCCDType());
        }
        ReadoutConfig readoutConfig = new ReadoutConfig(source.getSourceType());
        WritableIntChannel[] fileChannels = new WritableIntChannel[source.getLocation().type().getCCDCount() * 16];
        try {
            for (int i = 0; i < this.files.length; ++i) {
                int sensorIndex = readoutConfig.getDataSensorMap()[i];
                HashMap<String, Object> ccdProps = new HashMap<String, Object>();
                ccdProps.putAll(this.props);
                ccdProps.put("CCDSlot", source.getLocation().getSensorName(sensorIndex));
                PropertiesFitsHeaderMetadataProvider propsFitsHeaderMetadataProvider = new PropertiesFitsHeaderMetadataProvider(ccdProps);
                CCD ccd = (CCD)this.reb.getCCDs().get(sensorIndex);
                if (!ccd.getName().equals(ccdProps.get("CCDSlot"))) {
                    throw new IOException(String.format("Geometry (%s) inconsistent with DAQ location (%s)", ccd.getName(), ccdProps.get("CCDSlot")));
                }
                ReadOutImageSet imageSet = new ReadOutImageSet(Arrays.asList(readoutConfig.getDataSegmentNames()), readoutParameters);
                ArrayList<Object> providers = new ArrayList<Object>();
                providers.add(new GeometryFitsHeaderMetadataProvider(ccd));
                providers.add(propsFitsHeaderMetadataProvider);
                if (extraMetaDataProvider != null) {
                    providers.addAll(extraMetaDataProvider.getMetaDataProvider(ccd));
                }
                this.writers[i].createHDUs((ImageSet)imageSet, null, providers, RawImageData.BitsPerPixel.BIT32, headerSpecifications);
                int nImageExtensions = imageSet.getImageExtensionNames().size();
                for (int j = 0; j < nImageExtensions; ++j) {
                    fileChannels[i * nImageExtensions + j] = new FitsAsyncWriteChannel(this.writers[i], readoutConfig.getDataSegmentNames()[readoutConfig.getDataSegmentMap()[j]]);
                }
            }
            DemultiplexingIntChannel demultiplex = new DemultiplexingIntChannel(fileChannels);
            XORWritableIntChannel xor = new XORWritableIntChannel(demultiplex, readoutConfig.getXor());
            this.decompress = new Decompress18BitChannel(xor);
        }
        catch (IOException | RuntimeException | FitsException t) {
            this.cleanupOnError(this.reb.getLocation(), t);
        }
    }

    public FitsIntWriter(Source source, Reb reb, Map<String, HeaderSpecification> headerSpecifications, FileNamer fileNamer, PerCCDMetaDataProvider extraMetaDataProvider) throws DAQException, IOException {
        this(source.getImage(), reb, fileNamer);
        this.completeInitialization(source, headerSpecifications, extraMetaDataProvider);
    }

    public boolean isInitialized() {
        return this.isOpen();
    }

    @Override
    public void write(int i) throws IOException {
        this.decompress.write(i);
    }

    @Override
    public void write(IntBuffer buffer) throws IOException {
        this.decompress.write(buffer);
    }

    @Override
    public boolean isOpen() {
        return this.decompress != null && this.decompress.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.decompress != null) {
            this.decompress.close();
        }
        for (FitsFileWriter writer : this.writers) {
            if (writer == null) continue;
            writer.close();
        }
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(Arrays.asList(this.files));
    }

    static {
        FitsFactory.setUseHierarch(true);
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    }

    public static interface PerCCDMetaDataProvider {
        public List<FitsHeaderMetadataProvider> getMetaDataProvider(CCD var1);
    }

    public static interface FileNamer {
        public File computeFileName(Map<String, Object> var1);
    }
}

