/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.visualization.server.FitsFileManager;
import org.lsst.ccs.visualization.server.ImageListener;
import org.lsst.ccs.visualization.server.MessageHandler;

public class VisualizationIngestServer
implements Runnable {
    private final SocketAddress address;
    private final FitsFileManager ffManager;
    private static final Logger LOGGER = Logger.getLogger(VisualizationIngestServer.class.getName());
    private ServerSocketChannel server;
    private final Set<MessageHandler> weakMessageSet = Collections.newSetFromMap(new WeakHashMap());

    public VisualizationIngestServer(int port, File dir) {
        this(new InetSocketAddress(port), new FitsFileManager(dir));
    }

    VisualizationIngestServer(SocketAddress address, FitsFileManager ffManager) {
        this.address = address;
        this.ffManager = ffManager;
    }

    @Override
    public void run() {
        try {
            if (this.server == null || !this.server.isOpen()) {
                this.start();
            }
            while (true) {
                SocketChannel accept = this.server.accept();
                LOGGER.log(Level.INFO, "Accepted incoming connection from {0}", accept.getRemoteAddress());
                MessageHandler handler = new MessageHandler(accept, this.ffManager);
                this.weakMessageSet.add(handler);
                handler.start();
            }
        }
        catch (ClosedChannelException accept) {
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Uncaught IOException while handling sockets", ex);
        }
    }

    SocketAddress start() throws IOException {
        this.server = ServerSocketChannel.open();
        this.server.bind(this.address);
        LOGGER.log(Level.INFO, "Listening for incoming connection on {0}", this.server.getLocalAddress());
        return this.server.getLocalAddress();
    }

    public void shutdown() throws IOException {
        for (MessageHandler messageHandler : this.weakMessageSet) {
            messageHandler.close();
        }
        this.ffManager.cancel();
        this.server.close();
    }

    public Duration getStartTimeout() {
        return this.ffManager.getStartTimeout();
    }

    public void setStartTimeout(Duration startTimeout) {
        this.ffManager.setStartTimeout(startTimeout);
    }

    public Duration getActiveTimeout() {
        return this.ffManager.getActiveTimeout();
    }

    public void setActiveTimeout(Duration activeTimeout) {
        this.ffManager.setActiveTimeout(activeTimeout);
    }

    public Duration getStartWait() {
        return this.ffManager.getStartWait();
    }

    public void setStartWait(Duration startWait) {
        this.ffManager.setStartWait(startWait);
    }

    public void addImageListener(ImageListener l) {
        this.ffManager.addImageListener(l);
    }

    public void removeImageListener(ImageListener l) {
        this.ffManager.removeImageListener(l);
    }
}

