/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import org.lsst.ccs.utilities.ccd.Reb;

class FirmwareVersion {
    private final Reb.RebType rebType;
    private final int hwType;

    FirmwareVersion(int hwType) {
        this.hwType = hwType;
        int topNibble = hwType >> 28;
        this.rebType = Reb.RebType.values()[topNibble - 1];
    }

    boolean supportsMultiMains() {
        int lastThreeDigits = this.hwType & 0x7F;
        switch (this.rebType) {
            case SCIENCE: 
            case GUIDER: {
                return lastThreeDigits >= 6;
            }
            case WAVEFRONT: {
                return lastThreeDigits >= 4;
            }
        }
        throw new IllegalArgumentException("Invalid hwType " + this.hwType);
    }

    boolean hasLookAtMeBug() {
        int lastThreeDigits = this.hwType & 0x7F;
        if (this.rebType == Reb.RebType.GUIDER && lastThreeDigits >= 7) {
            return false;
        }
        return this.supportsMultiMains();
    }

    public String toString() {
        return String.format("FirmwareVersion{rebType=%s, hwType=%08x}", this.rebType, this.hwType);
    }
}

