package org.lsst.ccs.subsystem.focalplane;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;

/**
 * The instrument configuration object. Used by image database and for filling FITS
 * headers.
 * @author tonyj
 */
@SuppressWarnings("FieldMayBeFinal")
public class InstrumentConfig implements ConfigurationBulkChangeHandler {

    @ConfigurationParameter(category = "Instrument", isFinal=true, units = "unitless")
    private volatile String instrument = "MTCamera";
    
    @ConfigurationParameter(category = "Instrument", isFinal = true, units = "unitless")
    private volatile String testStand = "BOT";

    @ConfigurationParameter(category = "Instrument", isFinal = true, units = "unitless")
    private volatile String telescope = "LSST";    

    public String getInstrument() {
        return instrument;
    }

    public String getTestStand() {
        return testStand;
    }

    public String getTelescope() {
        return telescope;
    }
}
