/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.rafts.REBDevice;

public class TempControl
implements HasLifecycle {
    private static final String TEMP_CONTROL_CATEGORY = "RaftTempControl";
    private static final String TEMP_CONTROL_STATUS_CATEGORY = "RaftTempControlStatus";
    private static final Logger LOG = Logger.getLogger(TempControl.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupName
    private String name;
    @LookupPath
    private String path;
    private String raftPath;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private final Map<String, REBDevice> allRebs = new HashMap<String, REBDevice>();
    @ConfigurationParameter(category="RaftTempControl", description="maximum PID output", units="Watt")
    private double maxOutput = 5.6;
    @ConfigurationParameter(category="RaftTempControl", description="loop gain", units="unitless")
    private double gain = 0.1;
    @ConfigurationParameter(category="RaftTempControl", description="Temperature set point", units="C")
    private double setTemp;
    @ConfigurationParameter(category="RaftTempControlStatus", description="True if loop is active", units="unitless")
    private boolean active = false;
    @ConfigurationParameter(category="RaftTempControl", description="Temperature channels to use", units="unitless")
    private String[] tempChans = new String[]{"Reb0/S01/Temp", "Reb1/S11/Temp"};
    @ConfigurationParameter(category="RaftTempControl", description="The REBs with heaters to use", units="unitless")
    private String[] rebs = new String[]{"Reb0", "Reb2"};
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="input smoothing time", units="second")
    private double smoothTime = 20.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="anti-windup gain", units="unitless")
    private double awGain = 4.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="base power input", units="Watt")
    private double basePower = 0.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="maximum on-target error (%)", units="unitless")
    private double tolerance = 0.05;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="minimum PID output", units="Watt")
    private double minOutput = 0.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="maximum input", units="unitless")
    private double maxInput = 100.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="minimum input", units="unitless")
    private double minInput = -200.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="integration time constant", units="second")
    private double timeConst = 120.0;
    private PIController pic;
    private final List<Channel> tempChansL = new ArrayList<Channel>();
    private final List<REBDevice> rebsL = new ArrayList<REBDevice>();
    private double lastPower;

    public void build() {
        if (!this.raftPath.endsWith("/")) {
            this.raftPath = this.raftPath + "/";
        }
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("tempControl/" + this.raftPath.replace("/", ""), () -> this.iterateLoop()).withPeriod(Duration.ofMillis(30000L)));
    }

    public void postInit() {
        this.pic = new PIController(this.gain, this.timeConst);
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput);
        this.pic.setSmoothTime(this.smoothTime);
        this.pic.setAwGain(this.awGain);
        this.pic.setBaseOutput(this.basePower);
        this.pic.setTolerance(this.tolerance);
        this.setTemperatureChannels(this.tempChans);
        this.setPowerRebs(this.rebs);
        this.setTemperature(this.setTemp);
        this.setActive(this.active);
    }

    @ConfigurationParameterChanger(propertyName="active")
    public void setActive(boolean active) {
        if (this.pic != null) {
            if (active) {
                this.pic.reset();
                this.pic.setIntegral(this.lastPower - this.basePower);
            } else {
                this.setPower(0.0);
            }
        }
        this.active = active;
    }

    @ConfigurationParameterChanger(propertyName="maxOutput")
    public void setMaxOutput(double maxOutput) {
        if (this.pic != null) {
            this.pic.setOutputRange(this.minOutput, maxOutput);
        }
        this.maxOutput = maxOutput;
    }

    @ConfigurationParameterChanger(propertyName="gain")
    public void setGain(double gain) {
        if (this.pic != null) {
            this.pic.setPID(gain, this.timeConst);
        }
        this.gain = gain;
    }

    @ConfigurationParameterChanger(propertyName="setTemp")
    public void setTemperature(double temp) {
        this.setTemp = temp;
        if (this.pic != null) {
            this.pic.setSetpoint(this.setTemp);
        }
    }

    @ConfigurationParameterChanger(propertyName="tempChans")
    public void setTemperatureChannels(String[] tempChans) {
        ArrayList<Channel> tmpChansList = new ArrayList<Channel>();
        for (String cName : tempChans) {
            Channel chan = this.allChannels.get(this.raftPath + cName);
            if (chan == null) {
                RuntimeException e = new RuntimeException("Invalid configuration " + Arrays.asList(tempChans) + ". Channel " + cName + " does not exist in " + this.allChannels);
                e.printStackTrace();
                throw e;
            }
            tmpChansList.add(chan);
        }
        this.tempChansL.clear();
        this.tempChansL.addAll(tmpChansList);
        this.tempChans = tempChans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="rebs")
    public void setPowerRebs(String[] rebs) {
        ArrayList<REBDevice> tmpRebList = new ArrayList<REBDevice>();
        for (String cName : rebs) {
            REBDevice reb = this.allRebs.get(this.raftPath + cName);
            if (reb == null) {
                RuntimeException e = new RuntimeException("Invalid configuration " + Arrays.asList(rebs) + ". Reb Device " + this.raftPath + cName + " does not exist in " + this.allRebs);
                e.printStackTrace();
                throw e;
            }
            tmpRebList.add(reb);
        }
        List<REBDevice> list = this.rebsL;
        synchronized (list) {
            this.setPower(0.0);
            this.rebsL.clear();
            this.rebsL.addAll(tmpRebList);
        }
        this.rebs = rebs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPower(double power) {
        List<REBDevice> list = this.rebsL;
        synchronized (list) {
            for (REBDevice reb : this.rebsL) {
                try {
                    if (!reb.isOnline()) continue;
                    reb.setHeaterPower(0, power / (double)this.rebs.length);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error setting " + reb.getName() + "(isOnline:" + reb.isOnline() + ") heater", e);
                }
            }
        }
    }

    private void iterateLoop() {
        if (!this.active) {
            return;
        }
        int count = 0;
        double temp = 0.0;
        for (Channel tempChan : this.tempChansL) {
            double value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            temp += value;
            ++count;
        }
        if (count > 0) {
            double tod = (double)System.currentTimeMillis() / 1000.0;
            this.lastPower = this.pic.performPI(new double[]{temp / (double)count}, tod);
            this.setPower(this.lastPower);
        } else {
            LOG.log(Level.SEVERE, "Control loop iteration failed: no valid temperature values available");
        }
    }
}

