/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.Collection;
import java.util.Set;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinator;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class LSE71Commands {
    private static final LocationSet ALL_LOCATIONS = new LocationSet();
    private final FocalPlaneSubsystem subsys;

    LSE71Commands(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    @Command(type=Command.CommandType.ACTION, description="Perform a clear operation", level=0, autoAck=false)
    public void clear(@Argument(defaultValue="1") int nClears) {
        this.subsys.helper().precondition(nClears > 0 && nClears <= 15, "Invalid nClears: %d", new Object[]{nClears}).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).enterFaultOnException(true).action(() -> this.subsys.getSequencers().clear(nClears));
    }

    @Command(type=Command.CommandType.ACTION, description="Start integration", level=0, autoAck=false)
    public ImageName startIntegration(@Argument(defaultValue="") String annotation, @Argument(defaultValue="***NULL_VALUE_FOR_COMMAND_ARGUMENT***") Set locations) {
        return (ImageName)this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT}).precondition(this.subsys.getImageNameService() != null, "Image name service not available", new Object[0]).enterFaultOnException(true).action(() -> {
            ImageName in = this.subsys.getImageNameService().getImageName();
            ImageCoordinator currentImage = this.subsys.getImageCoordinatorService().createImageCoordinator(in);
            LocationSet localLocations = this.computeLocations(locations);
            if (localLocations.isEmpty()) {
                localLocations = this.subsys.getSequencers().getConfiguredLocations();
            }
            this.subsys.getSequencers().startIntegration(in, annotation, localLocations);
            currentImage.startIntegration(annotation, localLocations);
            return in;
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Start integration", level=0, autoAck=false)
    public void startNamedIntegration(@Argument ImageName imageName, @Argument(defaultValue="") String annotation, @Argument(defaultValue="***NULL_VALUE_FOR_COMMAND_ARGUMENT***") Set locations) {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.QUIESCENT}).enterFaultOnException(true).action(() -> {
            ImageName in = imageName;
            ImageCoordinator currentImage = this.subsys.getImageCoordinatorService().createImageCoordinator(in);
            LocationSet localLocations = this.computeLocations(locations);
            this.subsys.getSequencers().startIntegration(in, annotation, localLocations);
            currentImage.startIntegration(annotation, localLocations);
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Shift n rows", level=0, autoAck=false)
    public void shiftNRows(int nRows) {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.INTEGRATING}).enterFaultOnException(true).action(() -> this.subsys.getSequencers().rowShift(nRows));
    }

    @Command(type=Command.CommandType.ACTION, description="End exposure, and optionally read out", level=0, autoAck=false)
    public void endIntegration(@Argument(defaultValue="TRUE") ReadoutMode readout) {
        this.subsys.helper().precondition(new Enum[]{FocalPlaneState.INTEGRATING}).enterFaultOnException(true).action(() -> {
            Image image = this.subsys.getSequencers().endIntegration(readout);
            this.subsys.getImageCoordinatorService().endIntegration(readout, image);
        });
    }

    private LocationSet computeLocations(Set locations) {
        if (locations == null || locations.isEmpty()) {
            return ALL_LOCATIONS;
        }
        if (locations instanceof LocationSet) {
            return (LocationSet)locations;
        }
        LocationSet result = new LocationSet();
        for (Object o : locations) {
            if (o instanceof Location) {
                result.add((Location)o);
                continue;
            }
            if (o == null) continue;
            result.addAll((Collection)LocationSet.of((String[])new String[]{o.toString()}));
        }
        return result;
    }

    public static enum ReadoutMode {
        TRUE,
        FALSE,
        PSEUDO;

    }
}

