/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinatorUtilities;
import org.lsst.ccs.subsystem.focalplane.ImageDatabase;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.WebHooks;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.FitsFilesWrittenEvent;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ImageCoordinator {
    private static final Logger LOG = Logger.getLogger(ImageCoordinator.class.getName());
    private final ImageName imageName;
    private CCSTimeStamp lastClear;
    private double darkTime;
    private CCSTimeStamp integrationEnd;
    private Image image;
    private final ImageCoordinatorUtilities utilities;
    private final Phaser imageMetaDataEventCountdown;
    private CCSTimeStamp integrationStart;
    private final Phaser fitsFileCountdown;
    private final Phaser imageCountdown;
    private final ImageDatabase imageDatabase;
    private final int imageHandlersCount;
    private ImageDatabase.ImageDAO imageDAO;
    private Phaser imageDatabaseCountdown;
    private FileList fitsFiles = new FileList();
    private Exception fitsFileException;

    ImageCoordinator(ImageName name, final ImageCoordinatorUtilities utilities, final WebHooks webhooks, ImageDatabase imageDatabase, final int imageHandlersCount) {
        this.imageName = name;
        this.utilities = utilities;
        this.imageDatabase = imageDatabase;
        this.imageHandlersCount = imageHandlersCount;
        if (imageDatabase != null) {
            this.imageDAO = imageDatabase.start(this.imageName);
            this.imageDatabaseCountdown = new Phaser(5){

                @Override
                protected boolean onAdvance(int phase, int registeredParties) {
                    ImageCoordinator.this.imageDAO.commit();
                    return true;
                }
            };
        }
        this.imageMetaDataEventCountdown = new Phaser(3){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                ImageMetaDataEvent event = new ImageMetaDataEvent(ImageCoordinator.this.imageName, ImageCoordinator.this.darkTime, Long.toHexString(ImageCoordinator.this.image.getMetaData().getId()), ImageCoordinator.this.lastClear, ImageCoordinator.this.integrationStart, ImageCoordinator.this.integrationEnd);
                utilities.sendEvent(ImageMetaDataEvent.EVENT_KEY, (Serializable)event);
                return true;
            }
        };
        this.fitsFileCountdown = new Phaser(this.imageHandlersCount == 0 ? 1 : this.imageHandlersCount){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                if (ImageCoordinator.this.imageDAO != null) {
                    ImageCoordinator.this.imageDAO.add(ImageCoordinator.this.fitsFiles);
                    ImageCoordinator.this.imageDatabaseCountdown.arrive();
                }
                if (webhooks != null) {
                    webhooks.notifyNewImage(ImageCoordinator.this.imageName);
                }
                return true;
            }
        };
        this.imageCountdown = new Phaser(1){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                utilities.setStateIf(FocalPlaneState.IMAGE_WAIT, FocalPlaneState.QUIESCENT);
                if (imageHandlersCount == 0) {
                    ImageCoordinator.this.fitsFileCountdown.arrive();
                }
                return true;
            }
        };
    }

    void startIntegration(String annotation, LocationSet locations) {
        if (this.imageDAO != null) {
            this.imageDAO.setAnnotation(annotation);
            this.imageDAO.setLocations(locations);
            this.imageDatabaseCountdown.arrive();
        }
    }

    void endIntegration(LSE71Commands.ReadoutMode readoutMode, Image image) {
        this.image = image;
        this.imageMetaDataEventCountdown.arrive();
        if (this.imageDAO != null) {
            this.imageDAO.setDaqTag(image.getMetaData().getId());
            this.imageDatabaseCountdown.arrive();
        }
    }

    void imageCreated(Image image) {
        LOG.log(Level.INFO, "Image created {0}", image);
    }

    void imageComplete(Image image) {
        LOG.log(Level.INFO, "Image complete {0}", image);
        this.imageCountdown.arrive();
    }

    void addFitsFiles(FitsFilesWrittenEvent fitsFileEvent) {
        FileList fileList = fitsFileEvent.getFileList();
        if (fileList == null) {
            this.fitsFileException = fitsFileEvent.getException();
            this.fitsFileCountdown.forceTermination();
        } else {
            this.fitsFiles.addAll((Collection)fitsFileEvent.getFileList());
            this.fitsFileCountdown.arrive();
        }
    }

    ImageName getImageName() {
        return this.imageName;
    }

    FileList waitForFITSFiles(Duration timeout) throws InterruptedException, TimeoutException, ExecutionException {
        this.fitsFileCountdown.awaitAdvanceInterruptibly(0, timeout.toMillis(), TimeUnit.MILLISECONDS);
        if (this.fitsFileException != null) {
            throw new ExecutionException("Error while waiting for FITS filee", this.fitsFileException);
        }
        return this.fitsFiles;
    }

    void waitForImages(Duration timeout) throws TimeoutException, InterruptedException {
        this.imageCountdown.awaitAdvanceInterruptibly(0, timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    FocalPlaneState determineStateAfterReadout() {
        if (this.imageCountdown.isTerminated()) {
            return FocalPlaneState.QUIESCENT;
        }
        return FocalPlaneState.IMAGE_WAIT;
    }

    void startReadout(double darkTime, CCSTimeStamp integrationEnd, CCSTimeStamp lastClear) {
        this.darkTime = darkTime;
        this.integrationEnd = integrationEnd;
        this.lastClear = lastClear;
        this.imageMetaDataEventCountdown.arrive();
        if (this.imageDAO != null) {
            this.imageDAO.setDarkTime(darkTime);
            this.imageDatabaseCountdown.arrive();
        }
    }

    void startIntegrating(CCSTimeStamp integrationStart) {
        this.integrationStart = integrationStart;
        this.imageMetaDataEventCountdown.arrive();
        if (this.imageDAO != null) {
            this.imageDAO.setObsDate(integrationStart.getTAIInstant());
            this.imageDatabaseCountdown.arrive();
        }
    }

    void setMetaData(Map<String, Serializable> metaData) {
        LOG.log(Level.INFO, "Adding meta-data for image {0}: {1}", new Object[]{this.imageName, metaData});
        if (this.imageDAO != null) {
            this.imageDAO.addMetaData(metaData);
        }
    }
}

