/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.AlertRaisingAlarm;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.focalplane.alerts.FocalPlaneAlertType;
import org.lsst.ccs.subsystem.rafts.REBDevice;

public class FocalPlaneRebAlarm
extends AlertRaisingAlarm {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    REBDevice rebDevice;
    FocalPlaneAlertType alertType = null;

    public void build() {
        if (this.rebDevice == null) {
            throw new RuntimeException("A FocalPlaneRebAlarm must defined within a REBDevice.");
        }
        if (this.alertType == null) {
            throw new RuntimeException("An alert type must be specified.");
        }
        super.build();
        this.description = this.alertType.getDescription();
    }

    REBDevice getRebDevice() {
        return this.rebDevice;
    }

    public Alert getAlert(AlertState alertState, AlertState previousAlertState) {
        Alert alert = new Alert(this.alertType.getAlertId() + "/" + this.rebDevice.getPath(), this.alertType.getDescription());
        if ((this.alertType == FocalPlaneAlertType.ASPICS_TEMPERATURE_TOO_HIGH || this.alertType == FocalPlaneAlertType.REB_BOARD_TEMPERATURE_TOO_HIGH) && alertState == AlertState.ALARM) {
            RebPowerAction.addRebPowerActionPayloadToAlert((Alert)alert, (RebPowerAction.Type)RebPowerAction.Type.TURN_REB_OFF, (String)this.rebDevice.getPath());
        }
        return alert;
    }
}

