package org.lsst.ccs.subsystem.focalplane;

import org.lsst.ccs.utilities.ccd.Reb;

/**
 * Utility for interpreting REB firmware versions
 * @author tonyj
 */
class FirmwareVersion {

    private final Reb.RebType rebType;

    private final int hwType;

    FirmwareVersion(int hwType) {
        this.hwType = hwType;
        int topNibble = hwType >> 28;
        this.rebType = Reb.RebType.values()[topNibble-1];
    }

    boolean supportsMultiMains() {
        int lastThreeDigits = hwType & 0x7f;
        switch (rebType) {
            case SCIENCE:
            case GUIDER:
                return lastThreeDigits >= 6;
            case WAVEFRONT:
                return lastThreeDigits >= 4;
            default: 
                throw new IllegalArgumentException("Invalid hwType "+hwType);
        }
    }
    
    boolean hasLookAtMeBug() {
        // Correct until new firmware released
        return supportsMultiMains();
    }

    @Override
    public String toString() {
        return String.format("FirmwareVersion{rebType=%s, hwType=%08x}", rebType, hwType);
    }

}
