/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.location.Location;

public class Reb {
    private final String name;
    private final List<CCD> ccds = new ArrayList<CCD>();
    private final Raft parentRaft;
    private final RebType rebType;
    private CCDType ccdType;

    Reb(RebType rebType, String name, Raft raft) {
        this.rebType = rebType;
        this.name = name;
        this.parentRaft = raft;
    }

    void addCCD(CCD ccd) {
        if (this.ccdType == null) {
            this.ccdType = ccd.getType();
        } else if (!this.ccdType.equals(ccd.getType())) {
            throw new IllegalArgumentException("Cannot add CCD " + ccd.getName() + " due to inconsistent type. Expected type: " + this.ccdType.getName() + " while CCD type is " + ccd.getType().getName());
        }
        this.ccds.add(ccd);
        ccd.setParentReb(this);
    }

    public String getUniqueId() {
        return this.parentRaft != null ? this.parentRaft.getUniqueId() + "." + this.name : this.name;
    }

    public List<CCD> getCCDs() {
        return this.ccds;
    }

    public Raft getRaft() {
        return this.parentRaft;
    }

    public String getName() {
        return this.name;
    }

    public RebType getRebType() {
        return this.rebType;
    }

    public CCDType getCCDType() {
        return this.ccdType;
    }

    public String getFullName() {
        return this.parentRaft != null ? this.parentRaft.getName() + "/" + this.name : this.name;
    }

    public Location getLocation() {
        return Location.of(this.getFullName());
    }

    public String toString() {
        return this.getFullName();
    }

    public void setCCDType(CCDType type) {
        if (this.rebType != RebType.SCIENCE) {
            throw new RuntimeException("Reb type can only be changed for SCIENCE rebs " + (Object)((Object)this.rebType));
        }
        this.ccdType = type;
        for (CCD ccd : this.ccds) {
            ccd.setCcdType(type);
        }
    }

    public static enum RebType {
        WAVEFRONT,
        GUIDER,
        SCIENCE;

    }
}

