/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.rafts.GlobalVisualizationClient;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.pattern.FileNamePatternUtils;
import org.lsst.ccs.utilities.readout.GeometryFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.readout.ReadOutImageSet;
import org.lsst.ccs.utilities.readout.ReadOutParameters;
import org.lsst.ccs.utilities.readout.ReadOutParametersBuilder;
import org.lsst.ccs.utilities.readout.ReadOutParametersOld;

public class ImageProc {
    private String[] segmentsOrder = new String[]{"Segment10", "Segment11", "Segment12", "Segment13", "Segment14", "Segment15", "Segment16", "Segment17", "Segment07", "Segment06", "Segment05", "Segment04", "Segment03", "Segment02", "Segment01", "Segment00"};
    private int[] dataSegmentMap = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 7, 6, 5, 4, 3, 2, 1, 0};
    private static final int NUM_ADCS = 16;
    private static final int DATA_MASK_STRAIGHT = 131072;
    private static final int DATA_MASK_INVERTED = 131071;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private REBDevice reb;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private FitsService fitsService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private GlobalVisualizationClient globalVisualizationClient;
    private static final Logger LOG = Logger.getLogger(ImageProc.class.getName());
    private int ccdMask;
    private int numCcds;
    private int numRebCcds;
    private Image currImage = new Image();
    private ByteBuffer[][] currImageBuffer;
    private RaftException currImageExcp = new RaftException("No image data available");
    private int fitsSeqnum;
    private boolean externalSequenceNumber = false;
    private long imageTime;
    private String defaultDirectory = ".";
    private String fitsFileNamePattern = "Image_${rebName}_${sensorId}_${imageName}.fits";
    private String imageDataFileNamePattern = "Image_${rebName}_${imageName}.dat";
    private final Properties fileNamePatternProperties = new Properties();
    private Reb rebGeometry;
    private volatile ReadOutParameters readOutParameters;
    private int dataInversionMask = 131071;
    private final BlockingQueue<Integer> imageQueue = new ArrayBlockingQueue<Integer>(1);
    private final List<ImageListener> imageListeners = new CopyOnWriteArrayList<ImageListener>();
    private static final int[][] CCD_MAP = new int[][]{{-1, 0, -1, 0, -1, 0, -1, 0}, {-1, -1, 0, 1, -1, -1, 0, 1}, {-1, -1, -1, -1, 0, 1, 1, 2}};

    public void addImageListener(ImageListener l) {
        this.imageListeners.add(l);
    }

    public void removeImageListener(ImageListener l) {
        this.imageListeners.remove(l);
    }

    public ImageProc(ImageClient imc) {
        imc.setListener((ImageClient.Listener)new GetImage(), this.currImage);
        this.fileNamePatternProperties.setProperty("raftLoc", "99");
    }

    void setDataSegmentMap(int[] map) {
        if (map.length != this.dataSegmentMap.length) {
            throw new IllegalArgumentException("Invalid map length");
        }
        this.dataSegmentMap = map;
    }

    public void configure(Logger log) {
        this.fileNamePatternProperties.setProperty("rebName", this.reb.getName());
    }

    @Deprecated
    public void configure(String rebName, int rebId, Subsystem subsys, Logger log) {
        this.subsys = subsys;
        this.fileNamePatternProperties.setProperty("rebName", rebName);
    }

    public void setPatternProperty(String propertyName, String propertyValue) {
        this.fileNamePatternProperties.setProperty(propertyName, propertyValue);
    }

    public void setCcdMask(int ccdMask) {
        this.ccdMask = ccdMask;
        this.numCcds = Integer.bitCount(this.ccdMask);
    }

    public void setNumRebCcds(int numRebCcds) {
        this.numRebCcds = numRebCcds;
    }

    public void setRebGeometry(Reb reb) {
        this.rebGeometry = reb;
        this.fitsService.setGeometry(this.rebGeometry);
    }

    public void setDataInversion(boolean invert) {
        this.dataInversionMask = invert ? 131071 : 131072;
    }

    public void initImageWait() {
        this.imageQueue.clear();
    }

    public int waitForImage(int timeout) {
        Integer value = null;
        try {
            value = this.imageQueue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value != null ? 1 : 0;
    }

    public String saveImage(String dName) throws RaftException, IOException {
        if ((this.currImage.isInterleaved() ? this.currImage.getData() : this.currImage.getData(0)) == null) {
            throw new RaftException("Image contains no valid data");
        }
        String dirName = (dName == null || dName.isEmpty() ? this.defaultDirectory : dName) + "/";
        String filName = FileNamePatternUtils.resolveFileName((String)this.imageDataFileNamePattern, (Properties)this.fileNamePatternProperties);
        String shortFileName = Paths.get(filName, new String[0]).getFileName().toString();
        this.setFitsFileName(shortFileName);
        try (FileOutputStream ofs = new FileOutputStream(dirName + filName);){
            if (this.currImage.isInterleaved()) {
                ofs.getChannel().write(this.currImage.getData());
            } else {
                for (int ccd = 0; ccd < this.numCcds; ++ccd) {
                    ofs.getChannel().write(this.currImage.getData(ccd));
                }
            }
        }
        return filName;
    }

    void setExternalSequenceNumber(int sequenceNumber) {
        this.fitsSeqnum = sequenceNumber;
        this.externalSequenceNumber = true;
    }

    public List<String> saveFitsImage(String dName, FitsHeaderMetadataProvider provider) throws IOException, RaftException {
        return this.saveFitsImage(dName, provider, false);
    }

    public List<String> saveFitsImage(String dName, FitsHeaderMetadataProvider provider, boolean returnFullPaths) throws IOException, RaftException {
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        int numberOfColumns = this.readOutParameters.getSerialReadPixels();
        int numberOfRows = this.readOutParameters.getParallelReadPixels();
        if (this.currImageBuffer[0][0].limit() != 4 * numberOfColumns * numberOfRows) {
            throw new RaftException("Image size is inconsistent with slice count. Size: " + this.currImageBuffer[0][0].limit() / 4 + ", expected: " + numberOfColumns * numberOfRows + " (" + numberOfColumns + "x" + numberOfRows + ")");
        }
        ArrayList<String> names = new ArrayList<String>();
        String dirPatt = (dName == null || dName.isEmpty() ? this.defaultDirectory : dName) + "/";
        for (int ccd = 0; ccd < this.numCcds; ++ccd) {
            FitsFileWriter writer;
            int n;
            CCD ccdGeometry = (CCD)this.rebGeometry.getCCDs().get(ccd);
            ReadOutImageSet imageSet = new ReadOutImageSet(Arrays.asList(this.segmentsOrder), this.readOutParameters);
            if (this.externalSequenceNumber) {
                n = this.fitsSeqnum;
            } else {
                n = this.fitsSeqnum + 1;
                this.fitsSeqnum = this.fitsSeqnum;
            }
            this.fitsService.setHeaderKeywordValue("SequenceNumber", (Object)n);
            this.fitsService.setHeaderKeywordValue("FileCreationTime", (Object)new Date(System.currentTimeMillis()));
            this.fitsService.setHeaderKeywordValue("ObservationDate", (Object)new Date(this.imageTime));
            this.fitsService.setHeaderKeywordValue("Tag", (Object)String.valueOf(this.imageTime));
            try {
                ImageName in = new ImageName(this.currImage.getName());
                this.fitsService.setHeaderKeywordValue("ImageName", (Object)in.toString());
                this.fitsService.setHeaderKeywordValue("ImageDate", (Object)in.getDateString());
                this.fitsService.setHeaderKeywordValue("ImageNumber", (Object)in.getNumber());
                this.fitsService.setHeaderKeywordValue("ImageController", (Object)in.getController().getCode());
                this.fitsService.setHeaderKeywordValue("ImageSource", (Object)in.getSource().getCode());
                this.fileNamePatternProperties.setProperty("imageDate", in.getDateString());
                this.fileNamePatternProperties.setProperty("imageNumber", in.getNumberString());
                this.fileNamePatternProperties.setProperty("imageController", in.getController().getCode());
                this.fileNamePatternProperties.setProperty("imageSource", in.getSource().getCode());
            }
            catch (IllegalArgumentException x) {
                LOG.log(Level.FINE, "Error parsing {0}: {1}", new Object[]{this.currImage.getName(), x});
            }
            ArrayList<FitsHeaderMetadataProvider> providers = new ArrayList<FitsHeaderMetadataProvider>();
            providers.add(new ImageProcFitsHeaderMetadataProvider(ccdGeometry));
            providers.add(this.fitsService.getFitsHeaderMetadataProvider(ccdGeometry.getUniqueId()));
            providers.add((FitsHeaderMetadataProvider)new GeometryFitsHeaderMetadataProvider(ccdGeometry));
            if (provider != null) {
                providers.add(provider);
            }
            Properties resolverProperties = this.getPropertiesFromMetadataProviders(providers);
            this.fileNamePatternProperties.setProperty("sensorId", String.valueOf(ccd));
            this.fileNamePatternProperties.setProperty("sensorLoc", String.valueOf(this.reb.getRebNumber()) + String.valueOf(ccd));
            try {
                this.fileNamePatternProperties.setProperty("testType", resolverProperties.getProperty("TestType").toLowerCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.fileNamePatternProperties.setProperty("imageType", resolverProperties.getProperty("ImageType").toLowerCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            resolverProperties.putAll((Map<?, ?>)this.fileNamePatternProperties);
            String fileName = FileNamePatternUtils.resolveFileName((String)this.fitsFileNamePattern, (Properties)resolverProperties);
            String shortFileName = Paths.get(fileName, new String[0]).getFileName().toString();
            this.setFitsFileName(shortFileName);
            String dirName = FileNamePatternUtils.resolveFileName((String)dirPatt, (Properties)resolverProperties);
            File file = new File(dirName, fileName);
            file.getParentFile().mkdirs();
            try {
                writer = new FitsFileWriter(file, (ImageSet)imageSet, this.fitsService.getHeaderSpecificationMap(), providers);
            }
            catch (FitsException e) {
                throw new RaftException("FITS error: " + (Object)((Object)e));
            }
            for (int adc = 0; adc < 16; ++adc) {
                String segment = this.segmentsOrder[adc];
                int dataIndex = this.dataSegmentMap[adc];
                ByteBuffer buff = this.currImageBuffer[ccd][dataIndex];
                buff.rewind();
                writer.write(segment, buff);
            }
            writer.close();
            names.add(returnFullPaths ? file.getAbsolutePath() : file.getName());
        }
        this.fitsService.clearNonStickyHeaderKeywordValues();
        return names;
    }

    public List<String> saveFitsImage(String dName) throws IOException, RaftException {
        return this.saveFitsImage(dName, null);
    }

    private Properties getPropertiesFromMetadataProviders(List<FitsHeaderMetadataProvider> providers) {
        Properties p = new Properties();
        for (FitsHeaderMetadataProvider provider : providers) {
            MetaDataSet md = provider.getPrimaryHeaderMetadata();
            if (md == null) continue;
            p.putAll((Map<?, ?>)md.convertToProperties());
        }
        return p;
    }

    public ImageMetadata getImageMetadata() throws RaftException {
        return this.currImage.getMetadata();
    }

    public ImageData getImage(int ccd, int offset, int count) throws RaftException {
        if ((this.currImage.isInterleaved() ? this.currImage.getData() : this.currImage.getData(0)) == null) {
            throw new RaftException("Image contains no valid data");
        }
        int length = count;
        int iLength = this.currImage.getLength();
        if (length < 0 || offset < 0 || offset >= iLength) {
            throw new RaftException("Invalid length or offset");
        }
        if (length == 0 || length + offset > iLength) {
            length = iLength - offset;
        }
        int[] data = new int[length];
        ByteBuffer buff = this.currImage.isInterleaved() ? this.currImage.getData() : this.currImage.getData(ccd);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.position(4 * offset);
        buff.asIntBuffer().get(data);
        return new ImageData(this.currImage.getTimestamp(), offset, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImageData getImage(String fileName, int offset, int count) throws RaftException, IOException {
        MappedByteBuffer buff;
        offset *= 4;
        int length = 4 * count;
        try (FileInputStream ifs = new FileInputStream(fileName);){
            FileChannel chan = ifs.getChannel();
            long iLength = chan.size();
            if (length < 0 || offset < 0 || (long)offset >= iLength) {
                throw new RaftException("Invalid length or offset");
            }
            if (length == 0 || (long)(length + offset) > iLength) {
                length = (int)(iLength - (long)offset);
            }
            buff = chan.map(FileChannel.MapMode.READ_ONLY, offset, length);
        }
        int[] data = new int[length / 4];
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.asIntBuffer().get(data);
        return new ImageData(0L, offset / 4, data);
    }

    public double[][] getImageStats() throws RaftException {
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        double[][] stats = new double[this.numCcds * 16][2];
        for (int ccd = 0; ccd < this.numCcds; ++ccd) {
            for (int adc = 0; adc < 16; ++adc) {
                double sum = 0.0;
                double sumSq = 0.0;
                ByteBuffer buff = this.currImageBuffer[ccd][adc];
                int count = buff.limit() / 4;
                for (int k = 0; k < count; ++k) {
                    double value = buff.getInt();
                    sum += value;
                    sumSq += value * value;
                }
                double avg = sum / (double)count;
                int j = ccd * 16 + adc;
                stats[j][0] = avg;
                stats[j][1] = Math.sqrt(sumSq / (double)count - avg * avg);
            }
        }
        return stats;
    }

    public ByteBuffer[][] splitImage() throws RaftException {
        int adc;
        int ccd;
        int adc2;
        int buffSegs;
        ByteBuffer data;
        ByteBuffer byteBuffer = data = this.currImage.isInterleaved() ? this.currImage.getData() : this.currImage.getData(0);
        if (data == null || this.currImage.getStatus() != 0) {
            throw new RaftException("Image contains no valid data");
        }
        int numSeg = this.numCcds * 16;
        int n = buffSegs = this.currImage.isInterleaved() ? numSeg : 16;
        if (data.limit() % (4 * buffSegs) != 0) {
            throw new RaftException("Invalid image size: " + data.limit());
        }
        int segSize = data.limit() / buffSegs;
        ByteBuffer[][] adata = new ByteBuffer[this.numCcds][16];
        for (int ccd2 = 0; ccd2 < this.numCcds; ++ccd2) {
            for (adc2 = 0; adc2 < 16; ++adc2) {
                adata[ccd2][adc2] = ByteBuffer.allocate(segSize);
            }
        }
        if (this.currImage.isInterleaved()) {
            data.order(ByteOrder.nativeOrder());
            for (int j = 0; j < segSize / 4; ++j) {
                for (ccd = 0; ccd < this.numCcds; ++ccd) {
                    int actCcd = this.reb.getRebType() != 0 || this.numCcds < 3 ? ccd : this.numRebCcds - 1 - ccd;
                    for (adc = 0; adc < 16; ++adc) {
                        adata[actCcd][adc].putInt(data.getInt() ^ this.dataInversionMask);
                    }
                }
            }
        } else {
            ByteBuffer[] cdata = new ByteBuffer[this.numCcds];
            for (ccd = 0; ccd < this.numCcds; ++ccd) {
                cdata[ccd] = this.currImage.getData(ccd);
                cdata[ccd].order(ByteOrder.nativeOrder());
            }
            for (int j = 0; j < segSize / 4; ++j) {
                for (int ccd3 = 0; ccd3 < this.numCcds; ++ccd3) {
                    for (adc = 0; adc < 16; ++adc) {
                        adata[ccd3][adc].putInt(cdata[ccd3].getInt() ^ this.dataInversionMask);
                    }
                }
            }
        }
        for (int ccd4 = 0; ccd4 < this.numCcds; ++ccd4) {
            for (adc2 = 0; adc2 < 16; ++adc2) {
                adata[ccd4][adc2].flip();
            }
        }
        return adata;
    }

    private void setFitsFileName(String fitsFileName) {
        this.fitsService.setHeaderKeywordValue("OriginalFileName", (Object)fitsFileName);
    }

    public void setDefaultImageDirectory(String dirName) {
        this.defaultDirectory = dirName == null || dirName.isEmpty() ? "." : dirName;
    }

    public void setFitsFileNamePattern(String pattern) {
        this.fitsFileNamePattern = pattern;
    }

    public void setImageDataFileNamePattern(String pattern) {
        this.imageDataFileNamePattern = pattern;
    }

    public FitsService getFitsService() {
        return this.fitsService;
    }

    private static String timestampString(long tstamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(tstamp / 1000000L);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        return String.format("%tY%<tm%<td%<tH%<tM%<tS", cal);
    }

    private void analyzeImage(Segment segment, int ccdNum, Map<String, Object> imageMetaData) throws RaftException {
        double stdev;
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        int daqCcdNum = CCD_MAP[ccdNum][this.ccdMask];
        if (daqCcdNum < 0) {
            throw new RaftException("Invalid CCD number: " + ccdNum + "; CCD mask = " + this.ccdMask);
        }
        int dataIndex = -1;
        for (String segmentName : this.segmentsOrder) {
            ++dataIndex;
            if (segmentName.replace("Segment", "Seg").equals(segment.getName())) break;
        }
        ByteBuffer buff = this.currImageBuffer[daqCcdNum][this.dataSegmentMap[dataIndex]];
        buff.rewind();
        double pix_sum_active = 0.0;
        double pix_sum_sq_active = 0.0;
        int npix_active = 0;
        double pix_sum_bias = 0.0;
        double pix_sum_sq_bias = 0.0;
        int npix_bias = 0;
        int numberOfColumns = this.readOutParameters.getSerialReadPixels();
        int numberOfRows = this.readOutParameters.getParallelReadPixels();
        int segmentSerialActiveSize = segment.getSegmentSerialActiveSize();
        int serialPrescan = this.readOutParameters.getSerialPrescan();
        for (int row = 1; row <= numberOfRows; ++row) {
            for (int col = 1; col <= numberOfColumns; ++col) {
                double pixval = buff.getInt();
                if (col > serialPrescan && col <= serialPrescan + segmentSerialActiveSize) {
                    pix_sum_active += pixval;
                    pix_sum_sq_active += pixval * pixval;
                    ++npix_active;
                    continue;
                }
                if (col <= serialPrescan + segmentSerialActiveSize) continue;
                pix_sum_bias += pixval;
                pix_sum_sq_bias += pixval * pixval;
                ++npix_bias;
            }
        }
        LOG.log(Level.FINE, "Active {0} Bias {1} PreCols {2} ActiveSize {3} NCols {4} NRows {5}", new Object[]{npix_active, npix_bias, serialPrescan, segmentSerialActiveSize, numberOfColumns, numberOfRows});
        if (npix_active > 0) {
            double average = pix_sum_active / (double)npix_active;
            stdev = Math.sqrt(pix_sum_sq_active / (double)npix_active - average * average);
            LOG.log(Level.FINE, "Adding AVERAGE {0} STDEV {1}", new Object[]{average, stdev});
            imageMetaData.put("AVERAGE", average);
            imageMetaData.put("STDEV", stdev);
        }
        if (npix_bias > 0) {
            double average = pix_sum_bias / (double)npix_bias;
            stdev = Math.sqrt(pix_sum_sq_bias / (double)npix_bias - average * average);
            LOG.log(Level.FINE, "Adding AVGBIAS {0} STDVBIAS {1}", new Object[]{average, stdev});
            imageMetaData.put("AVGBIAS", average);
            imageMetaData.put("STDVBIAS", stdev);
        }
    }

    private ReadOutParameters createReadOutParametersFromRegistersMetadata(int[] registers) {
        return ReadOutParametersBuilder.create().ccdType(((CCD)this.rebGeometry.getCCDs().get(0)).getType()).readoutParameterValues(registers).readoutParameterNames(ReadOutParametersOld.DEFAULT_NAMES).build();
    }

    static /* synthetic */ ByteBuffer[][] access$302(ImageProc x0, ByteBuffer[][] x1) {
        x0.currImageBuffer = x1;
        return x1;
    }

    private class ImageProcFitsHeaderMetadataProvider
    implements FitsHeaderMetadataProvider {
        private final CCD ccd;

        ImageProcFitsHeaderMetadataProvider(CCD ccd) {
            this.ccd = ccd;
        }

        public MetaDataSet getPrimaryHeaderMetadata() {
            CCDType ccdType = this.ccd.getType();
            MetaDataSet m = new MetaDataSet();
            return m;
        }

        public MetaDataSet getDataExtendedHeaderMetadata(String segmentName) {
            MetaDataSet segmentMetaDataSet = new MetaDataSet();
            HashMap metadata = new HashMap();
            try {
                ImageProc.this.analyzeImage(this.ccd.getSegmentByName(segmentName), this.ccd.getSerialPosition(), metadata);
            }
            catch (RaftException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
            segmentMetaDataSet.addMetaDataMap("seg", metadata);
            return segmentMetaDataSet;
        }

        public MetaDataSet getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
            return null;
        }
    }

    public static interface ImageListener {
        public void imageReceived(ImageProc var1, Image var2);
    }

    private class GetImage
    implements ImageClient.Listener {
        private GetImage() {
        }

        public void processImage(Image image) {
            ImageProc.this.currImage = image;
            LOG.log(Level.INFO, "Received image: Reb = {0}, Name = {1}, Length = {2}, Status = {3}", new Object[]{ImageProc.this.reb.getName(), ImageProc.this.currImage.getName(), ImageProc.this.currImage.getLength(), ImageProc.this.currImage.getStatus()});
            try {
                ImageProc.access$302(ImageProc.this, ImageProc.this.splitImage());
                ImageProc.this.currImageExcp = null;
            }
            catch (RaftException e) {
                LOG.severe(e.getMessage());
                ImageProc.access$302(ImageProc.this, null);
                ImageProc.this.currImageExcp = e;
                return;
            }
            ImageProc.this.imageTime = ImageProc.this.currImage.getTimestamp() / 1000000L;
            String timestampString = ImageProc.timestampString(ImageProc.this.currImage.getTimestamp());
            ImageProc.this.fileNamePatternProperties.setProperty("timestamp", timestampString);
            ImageProc.this.fileNamePatternProperties.setProperty("imageName", ImageProc.this.currImage.getName() == null ? timestampString : ImageProc.this.currImage.getName());
            ImageProc.this.readOutParameters = ImageProc.this.createReadOutParametersFromRegistersMetadata(image.getRegisters());
            ImageProc.this.imageQueue.offer(0);
            for (ImageListener l : ImageProc.this.imageListeners) {
                l.imageReceived(ImageProc.this, image);
            }
            ImageState iState = new ImageState(ImageProc.this.currImage.getTimestamp(), ImageProc.this.currImage.getLength());
            KeyValueData kvd = new KeyValueData("ImageState", (Serializable)iState);
            ImageProc.this.subsys.publishSubsystemDataOnStatusBus(kvd);
            try {
                if (ImageProc.this.globalVisualizationClient != null && ImageProc.this.globalVisualizationClient.isConnected()) {
                    for (int ccd = 0; ccd < ImageProc.this.numCcds; ++ccd) {
                        CCD ccdGeometry = (CCD)ImageProc.this.rebGeometry.getCCDs().get(ccd);
                        ByteBuffer ccdData = ByteBuffer.allocate(ImageProc.this.readOutParameters.getTotalParallelSize() * ImageProc.this.readOutParameters.getTotalSerialSize() * 16 * 4);
                        for (int adc = 0; adc < 16; ++adc) {
                            ByteBuffer buff = ImageProc.this.currImageBuffer[ccd][adc];
                            ccdData.put(buff);
                            buff.rewind();
                        }
                        ccdData.rewind();
                        LOG.log(Level.FINE, "Sending image data {0}", image.getName());
                        ImageProc.this.globalVisualizationClient.sendImageData(image.getMetadata(), ccdData, ccdGeometry, ImageProc.this.readOutParameters);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

