/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.StoreSimulation;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.focalplane.CCDHardwareIdConfiguration;
import org.lsst.ccs.subsystem.focalplane.ConfigListener;
import org.lsst.ccs.subsystem.focalplane.FirmwareVersion;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneCommands;
import org.lsst.ccs.subsystem.focalplane.HardwareIdConfiguration;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinatorService;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinatorUtilities;
import org.lsst.ccs.subsystem.focalplane.ImageMessageHandling;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.ScriptingCommands;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.Sequencers;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.states.RebDeviceState;
import org.lsst.ccs.subsystem.rafts.states.RebValidationState;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FocalPlaneSubsystem
extends Subsystem
implements HasLifecycle,
HasDataProviderInfos,
ImageCoordinatorUtilities {
    private static final Logger LOG = Logger.getLogger(FocalPlaneSubsystem.class.getName());
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, REBDevice> rebDevices = new LinkedHashMap<String, REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private SequencerConfig sequencerConfig;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageNameService imageNameService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AlertService agentAlertService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageCoordinatorService imageCoordinatorService;
    private Sequencers sequencers;
    private final FocalPlane focalPlaneGeometry;
    private ImageMessageHandling imageMessageHandling;
    private ComponentLookup lookupService;
    private final boolean isSimulationMode;

    public FocalPlaneSubsystem(FocalPlane geometry) {
        super("fp", AgentInfo.AgentType.WORKER);
        this.focalPlaneGeometry = geometry;
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        this.isSimulationMode = "simulation".equalsIgnoreCase(props.getProperty("org.lsst.ccs.run.mode", "normal"));
        if (this.isSimulationMode) {
            LOG.log(Level.INFO, "Running in simulation mode");
        }
    }

    public void build() {
        this.agentPropertiesService.setAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, HasFocalPlaneData.generatePropertyValue(FocalPlaneDataGroup.class));
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.FOCAL_PLANE.name());
        this.agentPropertiesService.setAgentProperty(RebPowerAction.class.getCanonicalName(), "uses");
        this.lookupService = this.getComponentLookup();
        ComponentNode thisComponent = this.lookupService.getComponentNodeForObject((Object)this);
        this.imageMessageHandling = new ImageMessageHandling();
        ComponentNode imageMessageHandlingNode = new ComponentNode("imageMessageHandling", (Object)this.imageMessageHandling);
        this.lookupService.addComponentNodeToLookup(thisComponent, imageMessageHandlingNode);
        for (Raft r : this.focalPlaneGeometry.getChildrenList()) {
            ComponentNode raftNode = new ComponentNode(r.getName(), (Object)new HardwareIdConfiguration());
            this.lookupService.addComponentNodeToLookup(thisComponent, raftNode);
            for (Reb reb : r.getRebs()) {
                String rebName = r.getName() + "/" + reb.getName();
                ComponentNode rebHardwareNode = new ComponentNode(reb.getName() + "_hardware", (Object)new HardwareIdConfiguration());
                this.lookupService.addComponentNodeToLookup(raftNode, rebHardwareNode);
                ComponentNode rebComponent = this.lookupService.getNodeByPath(rebName);
                for (CCD ccd : reb.getCCDs()) {
                    String sensorName = ccd.getName();
                    ComponentNode sensorNode = new ComponentNode(sensorName, (Object)new CCDHardwareIdConfiguration());
                    this.lookupService.addComponentNodeToLookup(rebComponent, sensorNode);
                }
            }
        }
        this.agentStateService.registerState(FocalPlaneState.class, "The state of the Focal Plane", (Object)this);
    }

    public void init() {
        ClientFactorySimulation clientFactory = this.isSimulationMode ? new ClientFactorySimulation(true) : new ClientFactory();
        for (REBDevice rebDevice : this.rebDevices.values()) {
            rebDevice.setClientFactory((ClientFactory)clientFactory);
        }
        if (this.isSimulationMode) {
            GlobalClient gbl = new GlobalClient();
            gbl.setClientFactory((ClientFactory)clientFactory);
            try {
                gbl.open(this.sequencerConfig.getPartition());
                StoreSimulation.instance().addTriggerListener((opcode, meta, registerLists) -> {
                    try {
                        if (meta == null) {
                            gbl.startSequencer(opcode);
                        } else {
                            for (Map.Entry entry : registerLists.entrySet()) {
                                gbl.setRegisterlist(((Location.LocationType)entry.getKey()).getCCDCount(), (int[])entry.getValue());
                            }
                            int[] ids = new LocationSet(meta.getLocations()).asIntArray();
                            gbl.acquireImage(meta.getName(), meta.getCreationFolderName(), opcode, meta.getAnnotation(), ids);
                        }
                    }
                    catch (REBException x) {
                        LOG.log(Level.SEVERE, "Error simulating trigger", x);
                    }
                });
            }
            catch (REBException x) {
                throw new RuntimeException("Failed to initialize simulation", x);
            }
        }
    }

    public void postInit() {
        this.sequencers = new Sequencers(this, this.sequencerConfig);
        this.agentStateService.updateAgentState(new Enum[]{FocalPlaneState.NEEDS_CLEAR});
        this.dataProviderDictionaryService.registerClass(ImageMetaDataEvent.class, ImageMetaDataEvent.EVENT_KEY);
        this.rebDevices.forEach((rebName, device) -> {
            Reb reb = this.focalPlaneGeometry.getReb(rebName);
            device.setRebGeometry(reb);
            this.sequencers.add(reb, device.getSequencer());
        });
        this.agentStateService.addStateChangeListener(new StateChangeListener(){

            public void stateChanged(CCSTimeStamp stateTransitionTimestamp, Object device, Enum<?> newState, Enum<?> oldState) {
                if (newState == RebValidationState.VALID) {
                    REBDevice rebDevice = (REBDevice)device;
                    String path = FocalPlaneSubsystem.this.lookupService.getNameOfComponent(device);
                    try {
                        FirmwareVersion version = new FirmwareVersion(rebDevice.getHwVersion());
                        if (version.hasLookAtMeBug()) {
                            LOG.log(Level.INFO, "Disabled LAM for firmware {0}", version);
                            try {
                                rebDevice.setRegister(23, new int[]{0});
                            }
                            catch (RaftException x) {
                                LOG.log(Level.SEVERE, "Could not disable LAM for " + rebDevice.getName(), x);
                            }
                        }
                        FocalPlaneSubsystem.this.sequencers.load(FocalPlaneSubsystem.this.focalPlaneGeometry.getReb(path), version);
                        Integer result = rebDevice.loadAspics(true);
                        LOG.log(Level.INFO, "Loaded aspics for {0} result {1}", new Object[]{rebDevice.getName(), result});
                    }
                    catch (Exception x) {
                        LOG.log(Level.WARNING, "Exception while loading ASPICS", x);
                    }
                }
            }
        }, new Class[]{RebDeviceState.class, RebValidationState.class});
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new LSE71Commands(this), (Object)"");
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new ScriptingCommands(this), (Object)"");
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new FocalPlaneCommands(this), (Object)"");
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (AgentInfo ai : agents) {
                    if (!ai.getAgentProperty("agentCategory", "").equals(AgentCategory.POWER.name())) continue;
                    LOG.log(Level.INFO, "Publishing raised alert summary for {0}", new Object[]{ai.getName()});
                    FocalPlaneSubsystem.this.getScheduler().execute(() -> FocalPlaneSubsystem.this.agentAlertService.publishRaisedAlertSummary());
                    break;
                }
            }
        });
    }

    public void finalizeDictionary() {
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            FocalPlaneDataGroup dataGroup = FocalPlaneDataGroup.findFocalPlaneDataGroup((DataProviderInfo)data);
            if (dataGroup == null) continue;
            dataGroup.addAttributesToDataInfo(data);
        }
    }

    public void postStart() {
        this.configService.addConfigurationListener((ConfigurationListener)new ConfigListener(this));
        this.loadSequencers();
    }

    void loadSequencers() {
        try {
            this.sequencers.load();
        }
        catch (DAQException | REBException | RaftException x) {
            throw new RuntimeException("Error configuring sequencers", x);
        }
    }

    void loadASPICS() {
        for (REBDevice device : this.rebDevices.values()) {
            if (!device.isOnline() || !device.isSerialNumValid()) continue;
            try {
                Integer result = device.loadAspics(true);
                LOG.log(Level.INFO, "Loaded aspics for {0} result {1}", new Object[]{device.getFullName(), result});
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Error while loading ASPICS", ex);
            }
        }
    }

    boolean isRebOnlineAndValid(Reb reb) {
        return this.stateService.isComponentInState(reb.getFullName(), (Enum)RebValidationState.VALID);
    }

    FirmwareVersion getFirmwareVersionForReb(Reb reb) {
        return new FirmwareVersion(this.rebDevices.get(reb.getFullName()).getHwVersion());
    }

    public Sequencers getSequencers() {
        return this.sequencers;
    }

    ImageNameService getImageNameService() {
        return this.imageNameService;
    }

    Map<String, REBDevice> getRebDevices() {
        return this.rebDevices;
    }

    void loadSequencerParameters() {
        this.sequencers.loadSequencerParameters();
    }

    @Override
    public void sendEvent(String key, Serializable event) {
        KeyValueData kvd = new KeyValueData(key, event);
        this.publishSubsystemDataOnStatusBus(kvd);
        LOG.log(Level.INFO, "Sent: {0}", event);
    }

    void handleMetaData(Map<String, Serializable> headersMap) {
    }

    @Override
    public void setStateIf(FocalPlaneState currentState, FocalPlaneState newState) {
        if (this.agentStateService.getState(FocalPlaneState.class) == currentState) {
            this.agentStateService.updateAgentState(new Enum[]{newState});
        }
    }

    ImageCoordinatorService getImageCoordinatorService() {
        return this.imageCoordinatorService;
    }

    void setState(FocalPlaneState newState) {
        this.agentStateService.updateAgentState(new Enum[]{newState});
    }

    void setHeaderKeywords(Map<String, Serializable> headersMap) {
        FitsHeaderKeywordData data = new FitsHeaderKeywordData();
        for (Map.Entry<String, Serializable> e : headersMap.entrySet()) {
            data.addHeaderKeywordValue("all", e.getKey(), e.getValue(), false);
        }
        this.publishSubsystemDataOnStatusBus(data.getKeyValueData());
        this.imageCoordinatorService.addMetaData(headersMap);
    }
}

